/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.oauth2.BrowserClientRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleBrowserClientRequestUrl
extends BrowserClientRequestUrl {
    @Key(value="approval_prompt")
    private String approvalPrompt;

    public GoogleBrowserClientRequestUrl(String clientId, String redirectUri, Iterable<String> scopes) {
        super("https://accounts.google.com/o/oauth2/auth", clientId);
        this.setRedirectUri(redirectUri);
        this.setScopes((Iterable)scopes);
    }

    public GoogleBrowserClientRequestUrl(GoogleClientSecrets clientSecrets, String redirectUri, Iterable<String> scopes) {
        this(clientSecrets.getDetails().getClientId(), redirectUri, scopes);
    }

    public final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public GoogleBrowserClientRequestUrl setApprovalPrompt(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
        return this;
    }

    public GoogleBrowserClientRequestUrl setResponseTypes(String ... responseTypes) {
        return (GoogleBrowserClientRequestUrl)super.setResponseTypes(responseTypes);
    }

    public GoogleBrowserClientRequestUrl setResponseTypes(Iterable<String> responseTypes) {
        return (GoogleBrowserClientRequestUrl)super.setResponseTypes(responseTypes);
    }

    public GoogleBrowserClientRequestUrl setRedirectUri(String redirectUri) {
        return (GoogleBrowserClientRequestUrl)super.setRedirectUri(redirectUri);
    }

    public GoogleBrowserClientRequestUrl setScopes(String ... scopes) {
        Preconditions.checkArgument((scopes.length != 0 ? 1 : 0) != 0);
        return (GoogleBrowserClientRequestUrl)super.setScopes(scopes);
    }

    public GoogleBrowserClientRequestUrl setScopes(Iterable<String> scopes) {
        Preconditions.checkArgument((boolean)scopes.iterator().hasNext());
        return (GoogleBrowserClientRequestUrl)super.setScopes(scopes);
    }

    public GoogleBrowserClientRequestUrl setClientId(String clientId) {
        return (GoogleBrowserClientRequestUrl)super.setClientId(clientId);
    }

    public GoogleBrowserClientRequestUrl setState(String state) {
        return (GoogleBrowserClientRequestUrl)super.setState(state);
    }
}

