/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.el.ELContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstInvocation
extends AstRightValue {
    protected final List<AstNode> nodes;
    protected final boolean varargs;

    public AstInvocation(List<AstNode> nodes, boolean varargs) {
        this.nodes = nodes;
        this.varargs = varargs;
    }

    protected Object invoke(Bindings bindings, ELContext context, Object base, Method method) throws InvocationTargetException, IllegalAccessException {
        Object[] params;
        block3: {
            Class<?>[] types;
            block4: {
                Object array;
                block7: {
                    int length;
                    Class<?> varargType;
                    int varargIndex;
                    block5: {
                        Object param;
                        block6: {
                            types = method.getParameterTypes();
                            params = null;
                            if (types.length <= 0) break block3;
                            params = new Object[types.length];
                            if (!this.varargs || !method.isVarArgs()) break block4;
                            for (int i = 0; i < params.length - 1; ++i) {
                                Object param2 = this.getParam(i).eval(bindings, context);
                                if (param2 == null && !types[i].isPrimitive()) continue;
                                params[i] = bindings.convert(param2, types[i]);
                            }
                            varargIndex = types.length - 1;
                            varargType = types[varargIndex].getComponentType();
                            length = this.getParamCount() - varargIndex;
                            array = null;
                            if (length != 1) break block5;
                            param = this.getParam(varargIndex).eval(bindings, context);
                            if (!types[varargIndex].isInstance(param)) break block6;
                            array = param;
                            break block7;
                        }
                        array = Array.newInstance(varargType, 1);
                        if (param == null && !varargType.isPrimitive()) break block7;
                        Array.set(array, 0, bindings.convert(param, varargType));
                        break block7;
                    }
                    array = Array.newInstance(varargType, length);
                    for (int i = 0; i < length; ++i) {
                        Object param = this.getParam(varargIndex + i).eval(bindings, context);
                        if (param == null && !varargType.isPrimitive()) continue;
                        Array.set(array, i, bindings.convert(param, varargType));
                    }
                }
                params[varargIndex] = array;
                break block3;
            }
            for (int i = 0; i < params.length; ++i) {
                Object param = this.getParam(i).eval(bindings, context);
                if (param == null && !types[i].isPrimitive()) continue;
                params[i] = bindings.convert(param, types[i]);
            }
        }
        return method.invoke(base, params);
    }

    public int getParamCount() {
        return this.nodes == null ? 0 : this.nodes.size();
    }

    protected AstNode getParam(int i) {
        return this.nodes == null ? null : this.nodes.get(i);
    }

    public boolean isVarArgs() {
        return this.varargs;
    }
}

