/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.cache.ehcache;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.cache.Cache;
import org.jsecurity.cache.CacheException;
import org.jsecurity.cache.CacheManager;
import org.jsecurity.cache.ehcache.EhCache;
import org.jsecurity.io.ResourceUtils;
import org.jsecurity.util.Destroyable;
import org.jsecurity.util.Initializable;

public class EhCacheManager
implements CacheManager,
Initializable,
Destroyable {
    public static final String DEFAULT_ACTIVE_SESSIONS_CACHE_NAME = "jsecurity-activeSessionCache";
    public static final int DEFAULT_ACTIVE_SESSIONS_CACHE_MAX_ELEM_IN_MEM = 20000;
    public static final int DEFAULT_ACTIVE_SESSIONS_DISK_EXPIRY_THREAD_INTERVAL_SECONDS = 600;
    private static final Log log = LogFactory.getLog(EhCacheManager.class);
    protected net.sf.ehcache.CacheManager manager;
    private boolean cacheManagerImplicitlyCreated = false;
    private String cacheManagerConfigFile = "classpath:org/jsecurity/cache/ehcache/ehcache.xml";

    public net.sf.ehcache.CacheManager getCacheManager() {
        return this.manager;
    }

    public void setCacheManager(net.sf.ehcache.CacheManager manager) {
        this.manager = manager;
    }

    public String getCacheManagerConfigFile() {
        return this.cacheManagerConfigFile;
    }

    public void setCacheManagerConfigFile(String classpathLocation) {
        this.cacheManagerConfigFile = classpathLocation;
    }

    protected InputStream getCacheManagerConfigFileInputStream() {
        String configFile = this.getCacheManagerConfigFile();
        try {
            return ResourceUtils.getInputStreamForPath(configFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to obtain input stream for cacheManagerConfigFile.", e);
        }
    }

    public final Cache getCache(String name) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Loading a new EhCache cache named [" + name + "]"));
        }
        try {
            net.sf.ehcache.Cache cache = this.getCacheManager().getCache(name);
            if (cache == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Could not find a specific ehcache configuration for cache named [" + name + "]; using defaults."));
                }
                if (name.equals(DEFAULT_ACTIVE_SESSIONS_CACHE_NAME)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Creating jsecurity-activeSessionCache cache with default JSecurity session cache settings.");
                    }
                    cache = this.buildDefaultActiveSessionsCache();
                    this.manager.addCache(cache);
                } else {
                    this.manager.addCache(name);
                }
                cache = this.manager.getCache(name);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Started EHCache named [" + name + "]"));
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)("Using preconfigured EHCache named [" + cache.getName() + "]"));
            }
            return new EhCache(cache);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    private net.sf.ehcache.Cache buildDefaultActiveSessionsCache() throws CacheException {
        return new net.sf.ehcache.Cache(DEFAULT_ACTIVE_SESSIONS_CACHE_NAME, 20000, true, true, 0L, 0L, true, 600L);
    }

    public final void init() throws CacheException {
        try {
            net.sf.ehcache.CacheManager cacheMgr = this.getCacheManager();
            if (cacheMgr == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"cacheManager property not set.  Constructing CacheManager instance... ");
                }
                cacheMgr = new net.sf.ehcache.CacheManager(this.getCacheManagerConfigFileInputStream());
                if (log.isTraceEnabled()) {
                    log.trace((Object)"instantiated Ehcache CacheManager instance.");
                }
                this.cacheManagerImplicitlyCreated = true;
                this.setCacheManager(cacheMgr);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"implicit cacheManager created successfully.");
                }
            }
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void destroy() {
        if (this.cacheManagerImplicitlyCreated) {
            block3: {
                try {
                    net.sf.ehcache.CacheManager cacheMgr = this.getCacheManager();
                    cacheMgr.shutdown();
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"Unable to cleanly shutdown implicitly created CacheManager instance.  Ignoring (shutting down)...");
                }
            }
            this.cacheManagerImplicitlyCreated = false;
        }
    }
}

