/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.config;

import com.google.caja.config.ConfigMessageType;
import com.google.caja.config.ImportResolver;
import com.google.caja.config.TypeDefinitionImpl;
import com.google.caja.config.UriReader;
import com.google.caja.config.WhiteList;
import com.google.caja.config.WhiteListImpl;
import com.google.caja.config.WhiteListSkeleton;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONWhiteListLoader {
    final FilePosition src;
    final ImportResolver resolver;
    MessageQueue mq;
    private static final Map<URI, Pair<WhiteListSkeleton, List<Message>>> cache = Collections.synchronizedMap(new WeakHashMap());

    JSONWhiteListLoader(FilePosition src, ImportResolver resolver, MessageQueue mq) {
        this.src = src;
        this.resolver = resolver;
        this.mq = mq;
    }

    WhiteList loadFrom(Reader in) throws IOException, ParseException {
        return this.fromSkeleton(this.loadSkeleton(in));
    }

    WhiteList loadFrom(JSONObject value) throws IOException, ParseException {
        return this.fromSkeleton(this.loadSkeleton(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhiteListSkeleton loadSkeleton(Reader in) throws IOException, ParseException {
        URI uri;
        Pair<WhiteListSkeleton, List<Message>> p;
        if (in instanceof UriReader && (p = cache.get(uri = ((UriReader)in).getUri())) != null) {
            this.mq.getMessages().addAll((Collection)p.b);
            return (WhiteListSkeleton)p.a;
        }
        MessageQueue origMq = this.mq;
        SimpleMessageQueue cacheMq = new SimpleMessageQueue();
        this.mq = cacheMq;
        try {
            WhiteListSkeleton skel = this.loadSkeleton(this.expectJSONObject(JSONValue.parse((Reader)in), "whitelist"));
            if (in instanceof UriReader) {
                cache.put(((UriReader)in).getUri(), Pair.pair(skel, cacheMq.getMessages()));
            }
            WhiteListSkeleton whiteListSkeleton = skel;
            return whiteListSkeleton;
        }
        finally {
            this.mq = origMq;
            origMq.getMessages().addAll(cacheMq.getMessages());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhiteListSkeleton loadSkeleton(JSONObject whitelistJson) throws IOException, ParseException {
        JSONArray inherits = this.optionalJSONArray(whitelistJson.get((Object)"inherits"), "inherits");
        JSONArray allows = this.optionalJSONArray(whitelistJson.get((Object)"allowed"), "allowed");
        JSONArray denies = this.optionalJSONArray(whitelistJson.get((Object)"denied"), "denied");
        JSONArray types = this.optionalJSONArray(whitelistJson.get((Object)"types"), "types");
        for (Object key : whitelistJson.keySet()) {
            if ("inherits".equals(key) || "allowed".equals(key) || "denied".equals(key) || "types".equals(key) || "description".equals(key)) continue;
            this.mq.addMessage((MessageTypeInt)ConfigMessageType.UNRECOGNIZED_KEY, this.src, MessagePart.Factory.valueOf((String)key));
        }
        ArrayList<WhiteListSkeleton> inherited = new ArrayList<WhiteListSkeleton>();
        if (inherits != null) {
            for (Object obj : inherits) {
                String srcStr = obj instanceof String ? (String)obj : this.expectString(this.expectJSONObject(obj, "inherits").get((Object)"src"), "inherits src");
                try {
                    URI uri = this.src.source().getUri().resolve(new URI(srcStr));
                    Pair<Reader, FilePosition> loaded = this.resolver.resolve(uri, this.src.source().getUri(), this.src);
                    try {
                        inherited.add(new JSONWhiteListLoader((FilePosition)loaded.b, this.resolver, this.mq).loadSkeleton((Reader)loaded.a));
                    }
                    finally {
                        ((Reader)loaded.a).close();
                    }
                }
                catch (URISyntaxException ex) {
                    this.mq.addMessage((MessageTypeInt)ConfigMessageType.BAD_URL, this.src, MessagePart.Factory.valueOf(srcStr));
                }
            }
        }
        HashSet<String> allowedItemSet = new HashSet<String>();
        if (allows != null) {
            for (Object obj : allows) {
                String key = obj instanceof String ? (String)obj : this.expectString(this.expectJSONObject(obj, "allowed").get((Object)"key"), "allowed key");
                allowedItemSet.add(key);
            }
        }
        HashSet<String> deniedItemSet = new HashSet<String>();
        if (denies != null) {
            for (Object obj : denies) {
                String key = obj instanceof String ? (String)obj : this.expectString(this.expectJSONObject(obj, "denied").get((Object)"key"), "denied key");
                deniedItemSet.add(key);
            }
        }
        ArrayList<JSONObject> typeDefinitions = new ArrayList<JSONObject>();
        if (types != null) {
            for (Object obj : types) {
                JSONObject def = this.expectJSONObject(obj, "type");
                this.expectString(def.get((Object)"key"), "type key");
                typeDefinitions.add(def);
            }
        }
        return this.makeSkeleton(inherited, allowedItemSet, deniedItemSet, typeDefinitions);
    }

    WhiteListSkeleton makeSkeleton(List<WhiteListSkeleton> loaded, Set<String> allowed, Set<String> denied, List<JSONObject> definitions) {
        WhiteListSkeleton w = new WhiteListSkeleton();
        w.denied.addAll(denied);
        for (WhiteListSkeleton whiteListSkeleton : loaded) {
            w.allowed.addAll(whiteListSkeleton.allowed);
            for (Map.Entry<String, List<JSONObject>> e : whiteListSkeleton.definitions.entrySet()) {
                JSONWhiteListLoader.multimapAdd(w.definitions, e.getKey(), e.getValue());
            }
        }
        for (WhiteListSkeleton whiteListSkeleton : loaded) {
            w.allowed.removeAll(whiteListSkeleton.denied);
        }
        w.allowed.addAll(allowed);
        w.allowed.removeAll(denied);
        for (JSONObject jSONObject : definitions) {
            w.definitions.remove(jSONObject.get((Object)"key"));
        }
        for (JSONObject jSONObject : definitions) {
            JSONWhiteListLoader.multimapAdd(w.definitions, (String)jSONObject.get((Object)"key"), Collections.singletonList(jSONObject));
        }
        for (List list : w.definitions.values()) {
            if (list.size() == 1) continue;
            JSONObject definition = (JSONObject)list.get(0);
            List rest = list.subList(1, list.size());
            Iterator otherIt = rest.iterator();
            while (otherIt.hasNext()) {
                JSONObject other = (JSONObject)otherIt.next();
                if (!other.equals((Object)definition)) continue;
                otherIt.remove();
            }
        }
        return w;
    }

    void checkValidity(WhiteListSkeleton s) {
        for (Map.Entry<String, List<JSONObject>> def : s.definitions.entrySet()) {
            if (def.getValue().size() <= 1) continue;
            JSONObject first = def.getValue().get(0);
            JSONObject second = def.getValue().get(1);
            this.mq.addMessage((MessageTypeInt)ConfigMessageType.AMBIGUOUS_DEFINITION, this.src, MessagePart.Factory.valueOf("" + first), MessagePart.Factory.valueOf("" + second));
        }
    }

    WhiteList fromSkeleton(WhiteListSkeleton s) {
        this.checkValidity(s);
        HashMap<String, WhiteList.TypeDefinition> types = new HashMap<String, WhiteList.TypeDefinition>();
        for (Map.Entry<String, List<JSONObject>> def : s.definitions.entrySet()) {
            types.put(def.getKey(), this.makeTypeDefinition(def.getValue().get(0)));
        }
        return new WhiteListImpl(this.src.source(), s.allowed, types);
    }

    WhiteList.TypeDefinition makeTypeDefinition(JSONObject def) {
        return new TypeDefinitionImpl(JSONWhiteListLoader.immutable(def));
    }

    JSONObject expectJSONObject(Object obj, String part) throws ParseException {
        return this.expect(obj, JSONObject.class, part);
    }

    String expectString(Object obj, String part) throws ParseException {
        return this.expect(obj, String.class, part);
    }

    JSONArray optionalJSONArray(Object obj, String part) throws ParseException {
        return this.optional(obj, JSONArray.class, part);
    }

    static Map<String, Object> immutable(JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry e : json.entrySet()) {
            map.put((String)e.getKey(), JSONWhiteListLoader.immutable(e.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    static List<Object> immutable(JSONArray json) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object item : json) {
            list.add(JSONWhiteListLoader.immutable(item));
        }
        return Collections.unmodifiableList(list);
    }

    static Object immutable(Object obj) {
        if (obj instanceof JSONObject) {
            return JSONWhiteListLoader.immutable((JSONObject)obj);
        }
        if (obj instanceof JSONArray) {
            return JSONWhiteListLoader.immutable((JSONArray)obj);
        }
        if (obj == null || obj instanceof Boolean || obj instanceof Number || obj instanceof String) {
            return obj;
        }
        throw new AssertionError((Object)obj.getClass().getSimpleName());
    }

    <T> T expect(Object obj, Class<T> clazz, String part) throws ParseException {
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        throw new ParseException(new Message((MessageTypeInt)ConfigMessageType.MALFORMED_CONFIG, this.src, MessagePart.Factory.valueOf(part), MessagePart.Factory.valueOf(String.valueOf(obj))));
    }

    <T> T optional(Object obj, Class<T> clazz, String part) throws ParseException {
        if (obj == null) {
            return null;
        }
        return this.expect(obj, clazz, part);
    }

    static <K, V> void multimapAdd(Map<K, List<V>> m, K key, List<V> newValues) {
        if (newValues.isEmpty()) {
            return;
        }
        List<V> values = m.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            m.put(key, values);
        }
        values.addAll(newValues);
    }
}

