/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.reporting.MessageContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public interface MessagePart {
    public void format(MessageContext var1, Appendable var2) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        private Factory() {
        }

        public static MessagePart valueOf(String s) {
            return new MessagePartWrapper(s);
        }

        public static MessagePart valueOf(Number n) {
            return new MessagePartWrapper(n);
        }

        public static MessagePart valueOf(int n) {
            return new MessagePartWrapper(n);
        }

        public static MessagePart valueOf(long n) {
            return new MessagePartWrapper(n);
        }

        public static MessagePart valueOf(double n) {
            return new MessagePartWrapper(n);
        }

        public static MessagePart valueOf(Collection<?> parts) {
            MessagePart[] partArr = new MessagePart[parts.size()];
            int k = 0;
            for (Object p : parts) {
                if (!(p instanceof MessagePart)) {
                    p = p instanceof Number ? Factory.valueOf((Number)p) : Factory.valueOf(p.toString());
                }
                partArr[k++] = (MessagePart)p;
            }
            return new ArrayPart(partArr);
        }

        private static class ArrayPart
        implements MessagePart {
            private final MessagePart[] partArr;

            ArrayPart(MessagePart[] partArr) {
                this.partArr = partArr;
            }

            public void format(MessageContext context, Appendable out) throws IOException {
                for (int i = 0; i < this.partArr.length; ++i) {
                    if (0 != i) {
                        out.append(", ");
                    }
                    this.partArr[i].format(context, out);
                }
            }

            public String toString() {
                return Arrays.asList(this.partArr).toString();
            }

            public int hashCode() {
                return Arrays.hashCode(this.partArr) ^ 0x78ABCD35;
            }

            public boolean equals(Object o) {
                if (!(o instanceof ArrayPart)) {
                    return false;
                }
                ArrayPart that = (ArrayPart)o;
                if (that.partArr.length != this.partArr.length) {
                    return false;
                }
                int i = this.partArr.length;
                while (--i >= 0) {
                    if (this.partArr[i].equals(that.partArr[i])) continue;
                    return false;
                }
                return true;
            }
        }

        private static class MessagePartWrapper
        implements MessagePart {
            private final Object wrapped;

            MessagePartWrapper(Object wrapped) {
                if (wrapped == null) {
                    throw new NullPointerException();
                }
                this.wrapped = wrapped;
            }

            public void format(MessageContext context, Appendable out) throws IOException {
                out.append(this.wrapped.toString());
            }

            public boolean equals(Object o) {
                if (!(o instanceof MessagePartWrapper)) {
                    return false;
                }
                return this.wrapped.equals(((MessagePartWrapper)o).wrapped);
            }

            public int hashCode() {
                return this.wrapped.hashCode() ^ 0x2ED53AF2;
            }

            public String toString() {
                return this.wrapped.toString();
            }
        }
    }
}

