/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.model.impl;

import java.io.Serializable;
import org.nuxeo.ecm.diff.model.DifferenceType;
import org.nuxeo.ecm.diff.model.PropertyDiffDisplay;

public class PropertyDiffDisplayImpl
implements PropertyDiffDisplay {
    private static final long serialVersionUID = 875764424409126845L;
    protected Serializable value;
    protected DifferenceType differenceType;
    protected String styleClass = "noBackgroundColor";

    public PropertyDiffDisplayImpl(Serializable value) {
        this(value, DifferenceType.different);
    }

    public PropertyDiffDisplayImpl(Serializable value, DifferenceType differenceType) {
        this(value, differenceType, null);
    }

    public PropertyDiffDisplayImpl(Serializable value, String styleClass) {
        this(value, DifferenceType.different, styleClass);
    }

    public PropertyDiffDisplayImpl(Serializable value, DifferenceType differenceType, String styleClass) {
        this.value = value;
        this.differenceType = differenceType;
        this.styleClass = styleClass;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    @Override
    public DifferenceType getDifferenceType() {
        return this.differenceType;
    }

    public void setDifferenceType(DifferenceType differenceType) {
        this.differenceType = differenceType;
    }

    @Override
    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof PropertyDiffDisplay)) {
            return false;
        }
        Serializable otherValue = ((PropertyDiffDisplay)other).getValue();
        String otherStyleClass = ((PropertyDiffDisplay)other).getStyleClass();
        DifferenceType otherDifferenceType = ((PropertyDiffDisplay)other).getDifferenceType();
        if (this.value == null && otherValue == null && this.styleClass == null && otherStyleClass == null && this.differenceType.equals((Object)otherDifferenceType)) {
            return true;
        }
        return this.differenceType.equals((Object)otherDifferenceType) && (this.value == null && otherValue == null && this.styleClass != null && this.styleClass.equals(otherStyleClass) || this.styleClass == null && otherStyleClass == null && this.value != null && this.value.equals(otherValue) || this.value != null && this.value.equals(otherValue) && this.styleClass != null && this.styleClass.equals(otherStyleClass));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        sb.append(" / ");
        sb.append(this.differenceType.name());
        sb.append(" / ");
        sb.append(this.styleClass);
        return sb.toString();
    }
}

