/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client.core;

import org.nuxeo.gwt.habyt.upload.client.core.impl.DefaultInputFileWrapper;
import org.nuxeo.gwt.habyt.upload.client.core.impl.InputFileWrapperWithClick;
import org.nuxeo.gwt.habyt.upload.client.core.impl.SimpleInputFileWrapper;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public abstract class HijackStrategy {

    protected static int strategy = 0; // THE DEFAUL one

    public static void setDefault() {
        strategy = 0;
    }

    public static void setBasic() {
        strategy = 1;
    }

    public static void setHasClick() {
        strategy = 2;
    }

    public abstract InputFileWrapper getWrapper();

    public static class Default extends HijackStrategy {
        @Override
        public InputFileWrapper getWrapper() {
            if (strategy == 0) {
                return new DefaultInputFileWrapper();
            } else {
                return new SimpleInputFileWrapper();
            }
        }
    }

    public static class HasClick extends HijackStrategy {
        @Override
        public InputFileWrapper getWrapper() {
            if (strategy == 1) {
                return new SimpleInputFileWrapper();
            } else {
                return new InputFileWrapperWithClick();
            }
        }
    }

}
