/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.api;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QueryResult;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;

public class AnnotationImpl
implements Annotation,
Serializable {
    private static final long serialVersionUID = 1L;
    private Graph graph;

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Resource getSubject() {
        QueryResult result = this.graph.query("SELECT ?s WHERE {?s <http://www.w3.org/2000/10/annotation-ns#body> ?o}", "sparql", null);
        Node node = (Node)((Map)result.getResults().get(0)).get("s");
        return node.isBlank() ? null : (Resource)node;
    }

    @Override
    public void setBody(Statement body) {
        this.graph.add(body);
    }

    @Override
    public URI getAnnotates() throws AnnotationException {
        QueryResult result = this.graph.query("SELECT ?o WHERE {?s <http://www.w3.org/2000/10/annotation-ns#annotates> ?o}", "sparql", null);
        Node node = (Node)((Map)result.getResults().get(0)).get("o");
        try {
            return node.isBlank() ? null : new URI(((Resource)node).getUri());
        }
        catch (URISyntaxException e) {
            throw new AnnotationException(e);
        }
    }

    @Override
    public URI getBody() throws AnnotationException {
        QueryResult result = this.graph.query("SELECT ?o WHERE {?s <http://www.w3.org/2000/10/annotation-ns#body> ?o}", "sparql", null);
        Node node = (Node)((Map)result.getResults().get(0)).get("o");
        try {
            return node.isBlank() ? null : new URI(((Resource)node).getUri());
        }
        catch (URISyntaxException e) {
            throw new AnnotationException(e);
        }
    }

    @Override
    public String getBodyAsText() {
        QueryResult result = this.graph.query("SELECT ?o WHERE {?s <http://www.w3.org/2000/10/annotation-ns#body> ?o}", "sparql", null);
        Node node = (Node)((Map)result.getResults().get(0)).get("o");
        if (node.isLiteral()) {
            Literal literal = (Literal)node;
            return literal.getValue();
        }
        if (node.isResource()) {
            Resource resource = (Resource)node;
            return resource.getUri();
        }
        return null;
    }

    @Override
    public void setBodyText(String text) {
        QueryResult result = this.graph.query("SELECT ?s WHERE {?s <http://www.w3.org/2000/10/annotation-ns#body> ?o}", "sparql", null);
        Node s = (Node)((Map)result.getResults().get(0)).get("s");
        ResourceImpl p = new ResourceImpl("http://www.w3.org/2000/10/annotation-ns#body");
        this.graph.remove(this.graph.getStatements((Statement)new StatementImpl(s, (Node)p, null)));
        LiteralImpl o = new LiteralImpl(text);
        StatementImpl newStatement = new StatementImpl(s, (Node)p, (Node)o);
        this.graph.add((Statement)newStatement);
    }

    @Override
    public String getContext() throws AnnotationException {
        QueryResult result = this.graph.query("SELECT ?o WHERE {?s <http://www.w3.org/2000/10/annotation-ns#context> ?o}", "sparql", null);
        Node node = (Node)((Map)result.getResults().get(0)).get("o");
        return node.isBlank() ? null : ((Literal)node).getValue();
    }

    @Override
    public void setContext(Statement context) {
        this.graph.add(context);
    }

    @Override
    public List<Statement> getStatements() {
        return this.graph.getStatements();
    }

    @Override
    public void setStatements(List<Statement> statements) {
        this.graph.add(statements);
    }

    @Override
    public void setSubject(Resource resource) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Statement statement : this.graph.getStatements()) {
            statement.setSubject((Node)resource);
            statements.add(statement);
        }
        this.graph.clear();
        this.graph.add(statements);
    }

    @Override
    public void setAnnotates(Statement statement) {
        this.graph.add(statement);
    }

    @Override
    public String getCreator() {
        QueryResult result = this.graph.query("SELECT ?o WHERE {?s <http://purl.org/dc/elements/1.1/creator> ?o .}", "sparql", null);
        if (result.getCount() == 0) {
            return null;
        }
        Node node = (Node)((Map)result.getResults().get(0)).get("o");
        return node.isBlank() ? null : ((Literal)node).getValue();
    }

    @Override
    public void addMetadata(String predicate, String value) {
        StatementImpl statement = new StatementImpl((Node)this.getSubject(), (Node)new ResourceImpl(predicate), (Node)new LiteralImpl(value));
        this.graph.add((Statement)statement);
    }

    @Override
    public String getId() {
        Resource subject = this.getSubject();
        String uri = subject.getUri().toString();
        return uri.substring(uri.lastIndexOf(":"));
    }
}

