/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.plugin.Dom;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.stages.CheckForErrorsStage;
import com.google.caja.plugin.stages.CompileHtmlStage;
import com.google.caja.plugin.stages.ConsolidateCodeStage;
import com.google.caja.plugin.stages.DebuggingSymbolsStage;
import com.google.caja.plugin.stages.InferFilePositionsStage;
import com.google.caja.plugin.stages.InlineCssImportsStage;
import com.google.caja.plugin.stages.OpenTemplateStage;
import com.google.caja.plugin.stages.RewriteCssStage;
import com.google.caja.plugin.stages.RewriteHtmlStage;
import com.google.caja.plugin.stages.SanitizeHtmlStage;
import com.google.caja.plugin.stages.ValidateCssStage;
import com.google.caja.plugin.stages.ValidateJavascriptStage;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Criterion;
import com.google.caja.util.Pipeline;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginCompiler {
    private final BuildInfo buildInfo;
    private final Jobs jobs;
    private Pipeline<Jobs> compilationPipeline;
    private CssSchema cssSchema;
    private HtmlSchema htmlSchema;

    public PluginCompiler(BuildInfo buildInfo, PluginMeta meta, MessageQueue mq) {
        this.buildInfo = buildInfo;
        MessageContext mc = new MessageContext();
        this.jobs = new Jobs(mc, mq, meta);
        this.cssSchema = CssSchema.getDefaultCss21Schema(mq);
        this.htmlSchema = HtmlSchema.getDefault(mq);
    }

    public MessageQueue getMessageQueue() {
        return this.jobs.getMessageQueue();
    }

    public MessageContext getMessageContext() {
        return this.jobs.getMessageContext();
    }

    public void setMessageContext(MessageContext inputMessageContext) {
        assert (null != inputMessageContext);
        this.jobs.setMessageContext(inputMessageContext);
    }

    public PluginMeta getPluginMeta() {
        return this.jobs.getPluginMeta();
    }

    public Jobs getJobs() {
        return this.jobs;
    }

    public void setCssSchema(CssSchema cssSchema) {
        this.cssSchema = cssSchema;
        this.compilationPipeline = null;
    }

    public void setHtmlSchema(HtmlSchema htmlSchema) {
        this.htmlSchema = htmlSchema;
        this.compilationPipeline = null;
    }

    public void addInput(AncestorChain<?> input) {
        this.jobs.getJobs().add(new Job(input));
        this.jobs.getMessageContext().addInputSource(input.node.getFilePosition().source());
    }

    public List<? extends ParseTreeNode> getOutputs() {
        ArrayList<CajoledModule> outputs = new ArrayList<CajoledModule>();
        CajoledModule js = this.getJavascript();
        if (js != null) {
            outputs.add(js);
        }
        return outputs;
    }

    protected void setupCompilationPipeline() {
        this.compilationPipeline = new Pipeline<Jobs>(){
            final long t0 = System.nanoTime();

            @Override
            protected boolean applyStage(Pipeline.Stage<? super Jobs> stage, Jobs jobs) {
                jobs.getMessageQueue().addMessage((MessageTypeInt)MessageType.CHECKPOINT, MessagePart.Factory.valueOf(stage.getClass().getSimpleName()), MessagePart.Factory.valueOf((double)(System.nanoTime() - this.t0) / 1.0E9));
                return super.applyStage(stage, jobs);
            }
        };
        List<Pipeline.Stage<Jobs>> stages = this.compilationPipeline.getStages();
        stages.add(new RewriteHtmlStage());
        stages.add(new InlineCssImportsStage());
        stages.add(new SanitizeHtmlStage(this.htmlSchema));
        stages.add(new ValidateCssStage(this.cssSchema, this.htmlSchema));
        stages.add(new RewriteCssStage());
        stages.add(new CompileHtmlStage(this.cssSchema, this.htmlSchema));
        stages.add(new OpenTemplateStage());
        stages.add(new ConsolidateCodeStage());
        stages.add(new ValidateJavascriptStage(this.buildInfo));
        stages.add(new InferFilePositionsStage());
        stages.add(new DebuggingSymbolsStage());
        stages.add(new CheckForErrorsStage());
    }

    public Pipeline<Jobs> getCompilationPipeline() {
        if (this.compilationPipeline == null) {
            this.setupCompilationPipeline();
        }
        return this.compilationPipeline;
    }

    public Node getStaticHtml() {
        Job soleHtmlJob = this.getConsolidatedOutput(new Criterion<Job>(){

            @Override
            public boolean accept(Job job) {
                return job.getType() == Job.JobType.HTML;
            }
        });
        return soleHtmlJob != null ? ((Dom)soleHtmlJob.getRoot().cast(Dom.class).node).getValue() : null;
    }

    public CajoledModule getJavascript() {
        Job soleJsJob = this.getConsolidatedOutput(new Criterion<Job>(){

            @Override
            public boolean accept(Job job) {
                return job.getType() == Job.JobType.JAVASCRIPT;
            }
        });
        return soleJsJob != null ? (CajoledModule)soleJsJob.getRoot().node : null;
    }

    private Job getConsolidatedOutput(Criterion<Job> filter) {
        Job match = null;
        for (Job job : this.jobs.getJobs()) {
            if (!filter.accept(job)) continue;
            if (match != null) {
                throw new RuntimeException("Not consolidated.  Check your pipeline.");
            }
            match = job;
        }
        return match;
    }

    public boolean run() {
        return this.getCompilationPipeline().apply(this.jobs);
    }
}

