/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DomParserMessageType implements MessageTypeInt
{
    UNMATCHED_END("%s: end tag %s does not match open tag %s", MessageLevel.FATAL_ERROR),
    MISPLACED_CONTENT("%s: markup outside document", MessageLevel.ERROR),
    MISSING_END("%s: element %s at %s is not closed", MessageLevel.WARNING),
    IGNORING_TOKEN("%s: ignoring token %s", MessageLevel.WARNING),
    MOVING_TO_HEAD("%s: moving element %s to head", MessageLevel.LINT),
    MISSING_DOCUMENT_ELEMENT("%s: no document element", MessageLevel.ERROR),
    GENERIC_SAX_ERROR("%s: %s", MessageLevel.FATAL_ERROR);

    private final String formatString;
    private final MessageLevel level;
    private final int paramCount;

    private DomParserMessageType(String formatString, MessageLevel level) {
        this.formatString = formatString;
        this.level = level;
        this.paramCount = MessageType.formatStringArity(formatString);
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    @Override
    public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
        MessageType.formatMessage(this.formatString, parts, context, out);
    }

    @Override
    public MessageLevel getLevel() {
        return this.level;
    }
}

