/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.filter.authc;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jsecurity.subject.Subject;
import org.jsecurity.web.SavedRequest;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.filter.AccessControlFilter;

public abstract class AuthenticationFilter
extends AccessControlFilter {
    public static final String DEFAULT_SUCCESS_URL = "/index.jsp";
    private String successUrl = "/index.jsp";

    protected String getSuccessUrl() {
        return this.successUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Subject subject = this.getSubject(request, response);
        return subject.isAuthenticated();
    }

    protected void issueSuccessRedirect(ServletRequest request, ServletResponse response) throws Exception {
        String successUrl = null;
        boolean contextRelative = true;
        SavedRequest savedRequest = WebUtils.getAndClearSavedRequest(request);
        if (savedRequest != null && savedRequest.getMethod().equalsIgnoreCase("GET")) {
            successUrl = savedRequest.getRequestUrl();
            contextRelative = false;
        }
        if (successUrl == null) {
            successUrl = this.getSuccessUrl();
        }
        if (successUrl == null) {
            throw new IllegalStateException("Success URL not available via saved request or by calling getSuccessUrl().  One of these must be non-null for issueSuccessRedirect() to work.");
        }
        WebUtils.issueRedirect(request, response, successUrl, null, contextRelative);
    }
}

