/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Set;

public final class JsonCParser
extends JsonObjectParser {
    private final JsonFactory jsonFactory;

    public final JsonFactory getFactory() {
        return this.jsonFactory;
    }

    public JsonCParser(JsonFactory jsonFactory) {
        super(jsonFactory);
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonParser initializeParser(JsonParser parser) throws IOException {
        boolean failed = true;
        try {
            String match = parser.skipToKey((Set)Sets.newHashSet((Object[])new String[]{"data", "error"}));
            if (match == null || parser.getCurrentToken() == JsonToken.END_OBJECT) {
                throw new IllegalArgumentException("data key not found");
            }
            failed = false;
        }
        finally {
            if (failed) {
                parser.close();
            }
        }
        return parser;
    }

    public Object parseAndClose(InputStream in, Charset charset, Type dataType) throws IOException {
        return JsonCParser.initializeParser(this.jsonFactory.createJsonParser(in, charset)).parse(dataType, true, null);
    }

    public Object parseAndClose(Reader reader, Type dataType) throws IOException {
        return JsonCParser.initializeParser(this.jsonFactory.createJsonParser(reader)).parse(dataType, true, null);
    }
}

