/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authz.aop;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.UnauthorizedException;
import org.jsecurity.authz.annotation.RequiresRoles;
import org.jsecurity.authz.aop.AuthorizingAnnotationHandler;

public class RoleAnnotationHandler
extends AuthorizingAnnotationHandler {
    public RoleAnnotationHandler() {
        super(RequiresRoles.class);
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof RequiresRoles)) {
            return;
        }
        RequiresRoles rrAnnotation = (RequiresRoles)a;
        String roleId = rrAnnotation.value();
        String[] roles = roleId.split(",");
        if (roles.length == 1) {
            if (!this.getSubject().hasRole(roles[0])) {
                String msg = "Calling Subject does not have required role [" + roleId + "].  " + "MethodInvocation denied.";
                throw new UnauthorizedException(msg);
            }
        } else {
            LinkedHashSet<String> rolesSet = new LinkedHashSet<String>(Arrays.asList(roles));
            if (!this.getSubject().hasAllRoles(rolesSet)) {
                String msg = "Calling Subject does not have required roles [" + roleId + "].  " + "MethodInvocation denied.";
                throw new UnauthorizedException(msg);
            }
        }
    }
}

