/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.io;

import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.io.ResourceException;
import org.jsecurity.io.TextResource;
import org.jsecurity.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniResource
extends TextResource {
    private static final Log log = LogFactory.getLog(IniResource.class);
    public static final String COMMENT_POUND = "#";
    public static final String COMMENT_SEMICOLON = ";";
    public static final String HEADER_PREFIX = "[";
    public static final String HEADER_SUFFIX = "]";
    protected Map<String, Map<String, String>> sections = new LinkedHashMap<String, Map<String, String>>();

    public IniResource() {
    }

    public IniResource(String configBodyOrResourcePath) {
        this.load(configBodyOrResourcePath);
    }

    public IniResource(String configBodyOrResourcePath, String charsetName) {
        this.setCharsetName(charsetName);
        this.load(configBodyOrResourcePath);
    }

    public IniResource(InputStream is) {
        this.load(is);
    }

    public IniResource(Reader r) {
        this.load(r);
    }

    public IniResource(Scanner s) {
        this.load(s);
    }

    public Map<String, Map<String, String>> getSections() {
        return this.sections;
    }

    public void setSections(Map<String, Map<String, String>> sections) {
        this.sections = sections;
    }

    @Override
    public void load(Scanner scanner) {
        String currSectionName = null;
        LinkedHashMap<String, String> section = new LinkedHashMap<String, String>();
        while (scanner.hasNextLine()) {
            String line = StringUtils.clean(scanner.nextLine());
            if (line == null || line.startsWith(COMMENT_POUND) || line.startsWith(COMMENT_SEMICOLON)) continue;
            String sectionName = IniResource.getSectionName(line.toLowerCase());
            if (sectionName != null) {
                if (!section.isEmpty()) {
                    this.sections.put(currSectionName, section);
                }
                currSectionName = sectionName;
                section = new LinkedHashMap();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Parsing [" + currSectionName + HEADER_SUFFIX));
                continue;
            }
            try {
                String[] keyValue = StringUtils.splitKeyValue(line);
                section.put(keyValue[0], keyValue[1]);
            }
            catch (ParseException e) {
                String msg = "Unable to read key value pair for line [" + line + "].";
                throw new ResourceException(msg, e);
            }
        }
        if (!section.isEmpty()) {
            this.sections.put(currSectionName, section);
        }
    }

    protected static boolean isSectionHeader(String line) {
        String s = StringUtils.clean(line);
        return s != null && s.startsWith(HEADER_PREFIX) && s.endsWith(HEADER_SUFFIX);
    }

    protected static String getSectionName(String line) {
        String s = StringUtils.clean(line);
        if (IniResource.isSectionHeader(s)) {
            return StringUtils.clean(s.substring(1, s.length() - 1));
        }
        return null;
    }
}

