/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OAuthService {
    private EndPoint requestUrl;
    private EndPoint accessUrl;
    private Uri authorizationUrl;
    private String name;
    private static final String URL_ATTR = "url";
    private static final String PARAM_LOCATION_ATTR = "param_location";
    private static final String METHOD_ATTR = "method";

    OAuthService() {
    }

    public OAuthService(Element serviceElement, Uri base) throws SpecParserException {
        this.name = serviceElement.getAttribute("name");
        NodeList children = serviceElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            if (childName.equals("Request")) {
                if (this.requestUrl != null) {
                    throw new SpecParserException("Multiple OAuth/Service/Request elements");
                }
                this.requestUrl = this.parseEndPoint("OAuth/Service/Request", (Element)child, base);
                continue;
            }
            if (childName.equals("Authorization")) {
                if (this.authorizationUrl != null) {
                    throw new SpecParserException("Multiple OAuth/Service/Authorization elements");
                }
                this.authorizationUrl = this.parseAuthorizationUrl((Element)child, base);
                continue;
            }
            if (!childName.equals("Access")) continue;
            if (this.accessUrl != null) {
                throw new SpecParserException("Multiple OAuth/Service/Access elements");
            }
            this.accessUrl = this.parseEndPoint("OAuth/Service/Access", (Element)child, base);
        }
        if (this.requestUrl == null) {
            throw new SpecParserException("/OAuth/Service/Request is required");
        }
        if (this.accessUrl == null) {
            throw new SpecParserException("/OAuth/Service/Access is required");
        }
        if (this.authorizationUrl == null) {
            throw new SpecParserException("/OAuth/Service/Authorization is required");
        }
        if (this.requestUrl.location != this.accessUrl.location) {
            throw new SpecParserException("Access@location must be identical to Request@location");
        }
        if (this.requestUrl.method != this.accessUrl.method) {
            throw new SpecParserException("Access@method must be identical to Request@method");
        }
        if (this.requestUrl.location == Location.BODY && this.requestUrl.method == Method.GET) {
            throw new SpecParserException("Incompatible parameter location, cannotuse post-body with GET requests");
        }
    }

    public EndPoint getRequestUrl() {
        return this.requestUrl;
    }

    public EndPoint getAccessUrl() {
        return this.accessUrl;
    }

    public Uri getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getName() {
        return this.name;
    }

    Uri parseAuthorizationUrl(Element child, Uri base) throws SpecParserException {
        Uri url = XmlUtil.getHttpUriAttribute((Node)child, (String)URL_ATTR);
        if (url == null) {
            throw new SpecParserException("OAuth/Service/Authorization @url is not valid: " + child.getAttribute(URL_ATTR));
        }
        return base.resolve(url);
    }

    EndPoint parseEndPoint(String where, Element child, Uri base) throws SpecParserException {
        Uri url = XmlUtil.getHttpUriAttribute((Node)child, (String)URL_ATTR);
        if (url == null) {
            throw new SpecParserException("Not an HTTP url: " + child.getAttribute(URL_ATTR));
        }
        Location location = Location.parse(child.getAttribute(PARAM_LOCATION_ATTR));
        Method method = Method.parse(child.getAttribute(METHOD_ATTR));
        return new EndPoint(base.resolve(url), method, location);
    }

    public static class EndPoint {
        public final Uri url;
        public final Method method;
        public final Location location;

        public EndPoint(Uri url, Method method, Location location) {
            this.url = url;
            this.method = method;
            this.location = location;
        }

        public String toString(String element) {
            return '<' + element + " url='" + this.url.toString() + "' " + "method='" + (Object)((Object)this.method) + "' param_location='" + (Object)((Object)this.location) + "'/>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        HEADER("auth-header"),
        URL("uri-query"),
        BODY("post-body");

        private static Map<String, Location> LOCATIONS;
        private String locationString;

        private Location(String locationString) {
            this.locationString = locationString;
        }

        public String toString() {
            return this.locationString;
        }

        public static Location parse(String value) throws SpecParserException {
            Location result = LOCATIONS.get(value = value.trim());
            if (result == null) {
                throw new SpecParserException("Unknown OAuth param_location: " + value);
            }
            return result;
        }

        static {
            LOCATIONS = Maps.newHashMap();
            for (Location l : Location.values()) {
                LOCATIONS.put(l.locationString, l);
            }
            LOCATIONS.put("", HEADER);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        POST;

        private static final Map<String, Method> METHODS;

        public static Method parse(String value) throws SpecParserException {
            Method result = METHODS.get(value = value.trim());
            if (result == null) {
                throw new SpecParserException("Unknown OAuth method: " + value);
            }
            return result;
        }

        static {
            METHODS = ImmutableMap.of((Object)GET.toString(), (Object)((Object)GET), (Object)POST.toString(), (Object)((Object)POST), (Object)"", (Object)((Object)GET));
        }
    }
}

