/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.metadata;

import it.tidalwave.image.Rational;
import it.tidalwave.image.metadata.DirectoryAdapter;
import it.tidalwave.image.metadata.DirectoryDrewAdapter;
import it.tidalwave.image.metadata.DirectoryRawAdapter;
import it.tidalwave.image.metadata.DirectoryTIFFAdapter;
import it.tidalwave.image.metadata.EmptyDirectory;
import java.io.Serializable;
import java.lang.reflect.Method;

public class Directory
implements Serializable {
    private static final long serialVersionUID = 3088068666726854749L;
    protected DirectoryAdapter strategy = EmptyDirectory.getInstance();

    public void load(Object dir) {
        String className = dir.getClass().getName();
        if (this.isSubClass(dir.getClass(), "com.sun.media.imageioimpl.plugins.tiff.TIFFIFD")) {
            this.strategy = new DirectoryTIFFAdapter(dir);
        } else if (this.isSubClass(dir.getClass(), "com.drew.metadata.Directory")) {
            this.strategy = new DirectoryDrewAdapter(dir);
        } else if (this.isSubClass(dir.getClass(), "com.drew.metadata.exif.ExifDirectory")) {
            this.strategy = new DirectoryDrewAdapter(dir);
        } else if (this.isSubClass(dir.getClass(), "it.tidalwave.imageio.raw.Directory")) {
            this.strategy = new DirectoryRawAdapter(dir);
        }
    }

    public int[] getTagCodes() {
        return this.strategy.getTags();
    }

    public String[] getSubDirectoryNames() {
        return this.strategy.getSubDirectoryNames();
    }

    public Directory getSubDirectory(String name) {
        DirectoryAdapter adapter = this.strategy.getSubDirectory(name);
        if (adapter == null) {
            return null;
        }
        Directory directory = new Directory();
        directory.strategy = adapter;
        return directory;
    }

    public Object getObject(int tag) {
        Object value = this.strategy.getObject(tag);
        if (value instanceof Number) {
            try {
                try {
                    String methodName = "get" + Directory.strip(this.getTagName(tag));
                    Method method = this.getClass().getMethod(methodName, new Class[0]);
                    Class<?> returnType = method.getReturnType();
                    method = returnType.getMethod("getInstance", Integer.TYPE);
                    value = method.invoke(null, new Integer(((Number)value).intValue()));
                }
                catch (NoSuchMethodError e) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public String getTagName(int tag) {
        return this.strategy.getTagName(tag);
    }

    public boolean containsTag(int tag) {
        return this.strategy != null ? this.strategy.containsTag(tag) : false;
    }

    public String toString(byte[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length > 64) {
            return "" + array.length + " bytes";
        }
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(Integer.toHexString(array[i] & 0xFF));
        }
        return buffer.toString();
    }

    public String toString(int[] array) {
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(Integer.toString(array[i]));
        }
        return buffer.toString();
    }

    public String toString(double[] array) {
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(Double.toString(array[i]));
        }
        return buffer.toString();
    }

    public String toString(Rational[] array) {
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(array[i].toString());
        }
        return buffer.toString();
    }

    protected boolean isSubClass(Class aClass, String ancestorClassName) {
        while (aClass != null) {
            if (aClass.getName().equals(ancestorClassName)) {
                return true;
            }
            aClass = aClass.getSuperclass();
        }
        return false;
    }

    private static String strip(String s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            result.append(c);
        }
        return result.toString();
    }
}

