/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.request;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.oauth2.clients.ClientRegistry;
import org.nuxeo.ecm.platform.oauth2.request.Oauth2Request;
import org.nuxeo.ecm.platform.ui.web.auth.oauth2.NuxeoOAuth2Filter;
import org.nuxeo.runtime.api.Framework;

public class AuthorizationRequest
extends Oauth2Request {
    private static final Log log = LogFactory.getLog(AuthorizationRequest.class);
    protected static Map<String, AuthorizationRequest> requests = new HashMap<String, AuthorizationRequest>();
    protected String responseType;
    protected String scope;
    protected String state;
    protected String sessionId;
    protected Date creationDate;
    protected String authorizationCode;
    protected String authorizationKey;
    protected String username;
    public static final String RESPONSE_TYPE = "response_type";
    public static final String SCOPE = "scope";
    public static final String STATE = "state";

    public AuthorizationRequest() {
    }

    public AuthorizationRequest(HttpServletRequest request) {
        super(request);
        this.responseType = request.getParameter(RESPONSE_TYPE);
        this.scope = request.getParameter(SCOPE);
        this.state = request.getParameter(STATE);
        this.sessionId = request.getSession(true).getId();
        this.creationDate = new Date();
        this.authorizationKey = RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
    }

    public String checkError() {
        if (StringUtils.isBlank((String)this.responseType) || StringUtils.isBlank((String)this.clientId) || StringUtils.isBlank((String)this.redirectUri)) {
            return NuxeoOAuth2Filter.ERRORS.invalid_request.toString();
        }
        try {
            ClientRegistry registry = (ClientRegistry)Framework.getLocalService(ClientRegistry.class);
            if (!registry.hasClient(this.clientId)) {
                return NuxeoOAuth2Filter.ERRORS.unauthorized_client.toString();
            }
        }
        catch (ClientException e) {
            log.warn((Object)e, (Throwable)e);
            return NuxeoOAuth2Filter.ERRORS.server_error.toString();
        }
        if (!"code".equals(this.responseType)) {
            return NuxeoOAuth2Filter.ERRORS.unsupported_response_type.toString();
        }
        return null;
    }

    public boolean isExpired() {
        return new Date().getTime() - this.creationDate.getTime() > 600000L;
    }

    public boolean isValidState(HttpServletRequest request) {
        return StringUtils.isBlank((String)this.getState()) || request.getParameter(STATE).equals(this.getState());
    }

    public String getUsername() {
        return this.username;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getState() {
        return this.state;
    }

    public String getAuthorizationCode() {
        if (StringUtils.isBlank((String)this.authorizationCode)) {
            this.authorizationCode = RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
        }
        return this.authorizationCode;
    }

    public String getAuthorizationKey() {
        return this.authorizationKey;
    }

    private static void deleteExpiredRequests() {
        for (AuthorizationRequest req : requests.values()) {
            if (req == null) break;
            if (!req.isExpired()) continue;
            requests.remove(req.sessionId);
        }
    }

    public static AuthorizationRequest from(HttpServletRequest request) throws UnsupportedEncodingException {
        AuthorizationRequest authRequest;
        AuthorizationRequest.deleteExpiredRequests();
        String sessionId = request.getSession(true).getId();
        if (requests.containsKey(sessionId) && !(authRequest = requests.get(sessionId)).isExpired() && authRequest.isValidState(request)) {
            return authRequest;
        }
        authRequest = new AuthorizationRequest(request);
        requests.put(sessionId, authRequest);
        return authRequest;
    }

    public static AuthorizationRequest fromCode(String authorizationCode) {
        for (AuthorizationRequest auth : requests.values()) {
            if (auth.authorizationCode == null || !auth.authorizationCode.equals(authorizationCode)) continue;
            requests.remove(auth.sessionId);
            return auth.isExpired() ? null : auth;
        }
        return null;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

