/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.faceted.search.jsf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.faceted.search.jsf.localconfiguration.FacetedSearchConfiguration;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="facetedSearchConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class FacetedSearchConfigurationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<String> registeredContentView;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient ContentViewService contentViewService;

    public List<ContentViewHeader> getSelectedContentViewHeaders() throws Exception {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getSelectedContentViewHeaders(currentDoc);
    }

    public List<ContentViewHeader> getSelectedContentViewHeaders(DocumentModel document) throws Exception {
        if (!document.hasFacet("FacetedSearchLocalConfiguration")) {
            return Collections.emptyList();
        }
        List<String> notAllowedContentView = this.getDeniedContentViewNames(document);
        ArrayList<ContentViewHeader> allowedContentView = new ArrayList<ContentViewHeader>();
        for (String cvName : this.getRegisteredContentViews()) {
            if (notAllowedContentView.contains(cvName)) continue;
            allowedContentView.add(this.contentViewService.getContentViewHeader(cvName));
        }
        return allowedContentView;
    }

    public List<ContentViewHeader> getNotSelectedContentViewHeaders() throws Exception {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getNotSelectedContentViewHeaders(currentDoc);
    }

    public List<ContentViewHeader> getNotSelectedContentViewHeaders(DocumentModel document) throws Exception {
        if (!document.hasFacet("FacetedSearchLocalConfiguration")) {
            return Collections.emptyList();
        }
        return this.getContentViewHeaders(this.getDeniedContentViewNames(document));
    }

    protected List<String> getDeniedContentViewNames(DocumentModel doc) {
        FacetedSearchConfiguration adapter = (FacetedSearchConfiguration)doc.getAdapter(FacetedSearchConfiguration.class);
        if (adapter == null) {
            return Collections.emptyList();
        }
        return adapter.getDeniedContentViewNames();
    }

    protected List<ContentViewHeader> getContentViewHeaders(Collection<String> contentViewsNames) throws Exception {
        ArrayList<ContentViewHeader> contentViews = new ArrayList<ContentViewHeader>();
        for (String name : contentViewsNames) {
            contentViews.add(this.contentViewService.getContentViewHeader(name));
        }
        return contentViews;
    }

    protected Set<String> getRegisteredContentViews() throws Exception {
        if (this.registeredContentView == null) {
            this.registeredContentView = ((ContentViewService)Framework.getService(ContentViewService.class)).getContentViewNames("FACETED_SEARCH");
        }
        return this.registeredContentView;
    }
}

