/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.webengine.gadgets.render;

import freemarker.cache.TemplateLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.opensocial.gadgets.service.InternalGadgetDescriptor;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.webengine.gadgets.render.GadgetSpecRenderingEngine;
import org.nuxeo.opensocial.webengine.gadgets.render.GadgetTemplateLoader;
import org.nuxeo.opensocial.webengine.gadgets.render.Gadgeti18n;
import org.nuxeo.opensocial.webengine.gadgets.render.NuxeoContextHelper;
import org.nuxeo.runtime.api.Framework;

public class GadgetSpecView {
    protected static GadgetSpecRenderingEngine engine;
    protected static List<String> trustedHosts;
    public static Gadgeti18n i18n;

    protected static List<String> getTrustedHosts() {
        if (trustedHosts == null) {
            OpenSocialService os = (OpenSocialService)Framework.getLocalService(OpenSocialService.class);
            trustedHosts = new ArrayList<String>(Arrays.asList(os.getTrustedHosts()));
        }
        return trustedHosts;
    }

    protected static boolean isTrustedHostAccess(String url) {
        for (String host : GadgetSpecView.getTrustedHosts()) {
            if (!url.startsWith("http://" + host)) continue;
            return true;
        }
        return false;
    }

    protected static GadgetSpecRenderingEngine getEngine() {
        if (engine == null) {
            engine = new GadgetSpecRenderingEngine((TemplateLoader)new GadgetTemplateLoader());
        }
        return engine;
    }

    protected static boolean isInsideNuxeo(HttpServletRequest httpRequest) {
        String baseAccessUrl = VirtualHostHelper.getBaseURL((ServletRequest)httpRequest);
        if ("true".equals(httpRequest.getParameter("external"))) {
            return false;
        }
        if (!GadgetSpecView.isTrustedHostAccess(baseAccessUrl)) {
            return false;
        }
        String remoteIP = httpRequest.getRemoteAddr();
        OpenSocialService os = (OpenSocialService)Framework.getLocalService(OpenSocialService.class);
        return os.isTrustedHost(remoteIP);
    }

    protected static String getJSContext(Map<String, Object> input) {
        StringBuffer sb = new StringBuffer();
        sb.append("<script>\n");
        sb.append("var NXGadgetContext= {");
        for (String name : input.keySet()) {
            Object value = input.get(name);
            if (value instanceof String) {
                sb.append(name);
                sb.append(" : '");
                sb.append(value);
                sb.append("',\n");
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            sb.append(name);
            sb.append(" : ");
            sb.append(value.toString());
            sb.append(",\n");
        }
        sb.append("ts");
        sb.append(" : '");
        sb.append(System.currentTimeMillis());
        sb.append("'\n");
        sb.append("};\n");
        sb.append("</script>\n");
        return sb.toString();
    }

    public static InputStream render(InternalGadgetDescriptor gadget, Map<String, Object> params) throws Exception {
        String key = "gadget://" + gadget.getName();
        WebContext ctx = WebEngine.getActiveContext();
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("spec", gadget);
        HttpServletRequest httpRequest = ctx.getRequest();
        String specAccessUrl = VirtualHostHelper.getBaseURL((ServletRequest)httpRequest);
        input.put("contextPath", VirtualHostHelper.getContextPathProperty());
        if (GadgetSpecView.isInsideNuxeo(httpRequest)) {
            input.put("serverSideBaseUrl", Framework.getProperty((String)"nuxeo.loopback.url") + "/");
            input.put("clientSideBaseUrl", VirtualHostHelper.getContextPathProperty() + "/");
            input.put("specDirectoryUrl", VirtualHostHelper.getContextPathProperty() + "/site/gadgets/" + gadget.getName() + "/");
            input.put("insideNuxeo", true);
        } else {
            input.put("serverSideBaseUrl", specAccessUrl);
            input.put("clientSideBaseUrl", specAccessUrl);
            input.put("specDirectoryUrl", specAccessUrl + "site/gadgets/" + gadget.getName() + "/");
            input.put("insideNuxeo", false);
        }
        input.put("jsContext", GadgetSpecView.getJSContext(input));
        input.put("i18n", i18n);
        if (params != null) {
            input.putAll(params);
        }
        input.put("contextHelper", NuxeoContextHelper.getInstance());
        Enumeration pNames = httpRequest.getParameterNames();
        while (pNames.hasMoreElements()) {
            String name = (String)pNames.nextElement();
            input.put(name, httpRequest.getParameter(name));
        }
        StringWriter writer = new StringWriter();
        GadgetSpecView.getEngine().render(key, input, writer);
        return new ByteArrayInputStream(writer.getBuffer().toString().getBytes());
    }

    static {
        i18n = new Gadgeti18n();
    }
}

