/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.plugin.ExpressionSanitizerCaja;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.util.Pipeline;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidateJavascriptStage
implements Pipeline.Stage<Jobs> {
    private final BuildInfo buildInfo;

    public ValidateJavascriptStage(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    @Override
    public boolean apply(Jobs jobs) {
        ListIterator<Job> it = jobs.getJobs().listIterator();
        while (it.hasNext()) {
            AncestorChain<?> nonSyntheticScopeRoot;
            Job job = it.next();
            if (job.getType() != Job.JobType.JAVASCRIPT || (nonSyntheticScopeRoot = this.nonSyntheticScopeRoot(job.getRoot())) == null) continue;
            ParseTreeNode validated = new ExpressionSanitizerCaja(this.buildInfo, jobs.getMessageQueue()).sanitize(nonSyntheticScopeRoot);
            if (nonSyntheticScopeRoot.parent == null) {
                it.set(new Job(AncestorChain.instance(validated)));
                continue;
            }
            ((MutableParseTreeNode)nonSyntheticScopeRoot.parent.node).replaceChild(validated, (ParseTreeNode)nonSyntheticScopeRoot.node);
        }
        return jobs.hasNoFatalErrors();
    }

    public AncestorChain<?> nonSyntheticScopeRoot(AncestorChain<?> js) {
        AncestorChain<Object> scopeRoot = this.nonSyntheticRoot(js);
        if (scopeRoot == null) {
            return null;
        }
        while (scopeRoot.parent != null && !(scopeRoot.node instanceof Block)) {
            scopeRoot = scopeRoot.parent;
        }
        return scopeRoot;
    }

    public AncestorChain<?> nonSyntheticRoot(AncestorChain<?> js) {
        Object node = js.node;
        if (SyntheticNodes.isSynthesizable(node) && !node.getAttributes().is(SyntheticNodes.SYNTHETIC)) {
            return js;
        }
        AncestorChain<?> nonSyntheticChild = null;
        for (ParseTreeNode parseTreeNode : node.children()) {
            AncestorChain<?> result = this.nonSyntheticRoot(AncestorChain.instance(js, parseTreeNode));
            if (result == null) continue;
            if (nonSyntheticChild != null) {
                return js;
            }
            nonSyntheticChild = result;
        }
        return nonSyntheticChild;
    }
}

