/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

class BufferBackedSequence
implements CharSequence {
    private final int start;
    private final int end;
    private final char[] buf;

    BufferBackedSequence(char[] buf, int start, int end) {
        this.start = start;
        this.end = end;
        this.buf = buf;
    }

    public char charAt(int index) {
        return this.buf[this.start + index];
    }

    public int length() {
        return this.end - this.start;
    }

    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end < start || this.start + end > this.end) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return "";
        }
        if (start == 0 && end == this.end) {
            return this;
        }
        return new BufferBackedSequence(this.buf, start + this.start, end + this.start);
    }
}

