/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.ImageModel;
import it.tidalwave.image.InterpolationType;
import it.tidalwave.image.java2d.ImplementationFactoryJ2D;
import it.tidalwave.image.op.ImplementationFactory;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageModelJ2D
extends ImageModel {
    private static Logger logger = Logger.getLogger(ImageModelJ2D.class.getName());
    private static Map<InterpolationType, Object> interpolationMap = new HashMap<InterpolationType, Object>();
    private static Map<InterpolationType, Integer> interpolationMap2 = new HashMap<InterpolationType, Integer>();
    private static final List<String> ICC_PROFILES_WORKAROUND = Arrays.asList("sRGB IEC61966-2.1", "Nikon sRGB 4.0.0.3000", "Nikon sRGB 4.0.0.3001");
    private BufferedImage bufferedImage;

    public ImageModelJ2D() {
    }

    public ImageModelJ2D(Object bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("bufferedImage is null");
        }
        if (!(bufferedImage instanceof BufferedImage)) {
            throw new IllegalArgumentException("bufferedImage is not an instance of BufferedImage");
        }
        this.bufferedImage = (BufferedImage)bufferedImage;
    }

    @Override
    public ImplementationFactory getFactory() {
        return ImplementationFactoryJ2D.getInstance();
    }

    public static EditableImage createImage(BufferedImage bufferedImage) {
        assert (bufferedImage != null) : "bufferedImage is null";
        return new EditableImage(new ImageModelJ2D(bufferedImage));
    }

    @Override
    public Object getImage() {
        return this.bufferedImage;
    }

    @Override
    public void setImage(Object model) {
        super.setImage(model);
        this.bufferedImage = (BufferedImage)model;
    }

    @Override
    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    @Override
    public EditableImage.DataType getDataType() {
        return EditableImage.DataType.valueOf(this.bufferedImage.getRaster().getDataBuffer().getDataType());
    }

    @Override
    public int getBandCount() {
        return this.bufferedImage.getRaster().getNumBands();
    }

    @Override
    public void dispose() {
        this.bufferedImage = null;
    }

    @Override
    public ColorModel getColorModel() {
        return this.bufferedImage.getColorModel();
    }

    @Override
    public EditableImage createCopy(boolean copyContents) {
        logger.fine("createCopy(" + copyContents + ")");
        long time = System.currentTimeMillis();
        logger.warning(">>>> **** WARNING CREATECOPY DISABLED");
        BufferedImage result = this.bufferedImage;
        logger.fine(">>>> createCopy() completed ok in " + (System.currentTimeMillis() - time) + " msec");
        return ImageModelJ2D.createImage(result);
    }

    @Override
    public <T> T getInnerProperty(Class<T> propertyClass) {
        if (propertyClass.equals(BufferedImage.class)) {
            return (T)this.bufferedImage;
        }
        if (propertyClass.equals(SampleModel.class)) {
            return (T)this.bufferedImage.getSampleModel();
        }
        if (propertyClass.equals(ColorModel.class)) {
            return (T)this.bufferedImage.getColorModel();
        }
        throw new IllegalArgumentException(propertyClass.getName());
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        boolean notNull = this.bufferedImage != null;
        out.writeBoolean(notNull);
        if (notNull) {
            ImageIO.write((RenderedImage)this.bufferedImage, "TIFF", out);
        }
    }

    @Override
    public void readExternal(DataInputStream in) throws IOException {
        if (in.readBoolean()) {
            this.bufferedImage = ImageIO.read(in);
        }
    }

    public String toString() {
        return "ImageModelJ2D[image: " + this.bufferedImage + ", sampleModel: " + this.bufferedImage.getSampleModel() + "]";
    }

    static {
        interpolationMap.put(InterpolationType.FASTEST, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        interpolationMap.put(InterpolationType.NEAREST_NEIGHBOR, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        interpolationMap.put(InterpolationType.BILINEAR, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        interpolationMap.put(InterpolationType.BICUBIC, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        interpolationMap.put(InterpolationType.BEST, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        interpolationMap2.put(InterpolationType.FASTEST, new Integer(1));
        interpolationMap2.put(InterpolationType.NEAREST_NEIGHBOR, new Integer(1));
        interpolationMap2.put(InterpolationType.BILINEAR, new Integer(2));
        interpolationMap2.put(InterpolationType.BICUBIC, new Integer(2));
        interpolationMap2.put(InterpolationType.BEST, new Integer(2));
    }
}

