/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.tools;

import it.tidalwave.image.tools.TestResults;
import java.io.PrintWriter;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestInfo
implements Comparable<TestInfo> {
    private final String revision;
    private final String test;
    private final String quality;
    private final String file;
    private Set<TestResults> results = new TreeSet<TestResults>();
    private static String latestTest = "";
    private String[] colors = new String[]{"#ffffff", "#dddddd"};
    private static int k;

    public TestInfo(String body) {
        System.err.println(body);
        String[] tmp = body.split("::");
        this.revision = tmp[0];
        this.test = tmp[3];
        this.quality = tmp[4];
        this.file = tmp[5];
    }

    public void add(TestResults testResults) {
        this.results.add(testResults);
    }

    public void printHeader(PrintWriter pw) {
        pw.println("<tr><td rowspan='2'>Revision</td><td rowspan='2'>Test</td><td rowspan='2'>Quality</td><td rowspan='2'>File</td>");
        for (TestResults testResults : this.results) {
            pw.println("<td>" + testResults.host + "</td>");
        }
        pw.println("</tr>");
        pw.println("<tr>");
        for (TestResults testResults : this.results) {
            pw.println("<td>" + testResults.os + "</td>");
        }
        pw.println("</tr>");
    }

    public void print(PrintWriter pw) {
        if (!latestTest.equals(this.test + this.quality)) {
            ++k;
            latestTest = this.test + this.quality;
        }
        pw.print("<tr bgcolor='" + this.colors[k % this.colors.length] + "'><td align='right'>" + this.revision + "</td>");
        pw.print("<td>" + this.test + "</td>");
        pw.print("<td>" + this.quality + "</td>");
        pw.print("<td>" + this.file + "</td>");
        for (TestResults testResults : this.results) {
            testResults.print(pw);
        }
        pw.println("</tr>");
    }

    @Override
    public int compareTo(TestInfo o) {
        String oRevision;
        int r = this.test.compareTo(o.test);
        if (r != 0) {
            return r;
        }
        r = this.quality.compareTo(o.quality);
        if (r != 0) {
            return r;
        }
        r = this.file.compareTo(o.file);
        if (r != 0) {
            return r;
        }
        String tRevision = this.revision;
        int i = tRevision.lastIndexOf(46);
        if (i > 0) {
            tRevision = this.revision.substring(i + 1);
        }
        if ((i = (oRevision = o.revision).lastIndexOf(46)) > 0) {
            oRevision = oRevision.substring(i + 1);
        }
        r = tRevision.compareTo(oRevision);
        return r;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TestInfo)) {
            return false;
        }
        return this.compareTo((TestInfo)o) == 0;
    }

    public int hashcode() {
        return this.revision.hashCode() ^ this.test.hashCode() ^ this.quality.hashCode() ^ this.file.hashCode();
    }
}

