/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.BasicSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.common.util.Utf8UrlCoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BasicSecurityTokenDecoder
implements SecurityTokenDecoder {
    private static final int OWNER_INDEX = 0;
    private static final int VIEWER_INDEX = 1;
    private static final int APP_ID_INDEX = 2;
    private static final int DOMAIN_INDEX = 3;
    private static final int APP_URL_INDEX = 4;
    private static final int MODULE_ID_INDEX = 5;
    private static final int CONTAINER_ID_INDEX = 6;
    private static final int TOKEN_COUNT = 7;

    public String encodeToken(SecurityToken token) {
        return Joiner.on((String)":").join((Object)Utf8UrlCoder.encode(token.getOwnerId()), (Object)Utf8UrlCoder.encode(token.getViewerId()), new Object[]{Utf8UrlCoder.encode(token.getAppId()), Utf8UrlCoder.encode(token.getDomain()), Utf8UrlCoder.encode(token.getAppUrl()), Long.toString(token.getModuleId()), Utf8UrlCoder.encode(token.getContainer())});
    }

    @Override
    public SecurityToken createToken(Map<String, String> parameters) throws SecurityTokenException {
        String token = parameters.get("token");
        if (token == null || token.trim().length() == 0) {
            return new AnonymousSecurityToken();
        }
        try {
            String[] tokens = StringUtils.split((String)token, (char)':');
            if (tokens.length != 7) {
                throw new SecurityTokenException("Malformed security token");
            }
            return new BasicSecurityToken(Utf8UrlCoder.decode(tokens[0]), Utf8UrlCoder.decode(tokens[1]), Utf8UrlCoder.decode(tokens[2]), Utf8UrlCoder.decode(tokens[3]), Utf8UrlCoder.decode(tokens[4]), Utf8UrlCoder.decode(tokens[5]), Utf8UrlCoder.decode(tokens[6]), parameters.get("activeUrl"));
        }
        catch (BlobCrypterException e) {
            throw new SecurityTokenException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SecurityTokenException(e);
        }
    }
}

