/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.Request;
import com.google.caja.ancillary.servlet.StaticFiles;
import com.google.caja.ancillary.servlet.Verb;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.HtmlQuasiBuilder;
import com.google.caja.parser.html.Namespaces;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

final class HelpPage {
    private static final String HTML_NS = Namespaces.HTML_NAMESPACE_URI;

    HelpPage() {
    }

    static DocumentFragment render(StaticFiles staticFiles) {
        Document doc = DomParser.makeDocument(null, null);
        HtmlQuasiBuilder b = HtmlQuasiBuilder.getBuilder(doc);
        DocumentFragment out = doc.createDocumentFragment();
        out.appendChild(b.substV("<html><head><meta http-equiv=Content-Type content=text/html;charset=UTF-8 /><title>Caja Web Tools Help</title><link rel=stylesheet type=text/css href=files-@cacheId/styles.css></head><body><h1>Caja Web Tools Help</h1><p>Below are the URLs paths and parameters that show how to apply the Caja web tools to your web application.  Use the <a href=@index>interactive form</a> to experiment.</p>@verbs</body></html>", "index", Verb.INDEX.requestPath, "verbs", HelpPage.renderVerbHelp(b), "cacheId", staticFiles.cacheId));
        return out;
    }

    private static Element renderVerbHelp(HtmlQuasiBuilder b) {
        Element verbs = b.getDocument().createElementNS(HTML_NS, "ul");
        verbs.setAttributeNS(HTML_NS, "class", "verbs-help");
        for (Verb v : Verb.values()) {
            Object reqPath = v.requestPath;
            if (v == Verb.INDEX) {
                reqPath = b.substV("<a href=@reqPath>@reqPath</a>", "reqPath", reqPath);
            }
            verbs.appendChild(b.substV("<li><span class=verb>@reqPath</span>  &mdash; @manual @params</li>", "reqPath", reqPath, "manual", v.manual, "params", HelpPage.renderParamHelp(v, b)));
        }
        return verbs;
    }

    private static Element renderParamHelp(Verb v, HtmlQuasiBuilder b) {
        Element params = b.getDocument().createElementNS(HTML_NS, "table");
        String pn = "?";
        for (String name : Request.paramsAllowed(v)) {
            params.appendChild(b.substV("<tr><th>@pn@name=&hellip;</th><td>@manual</td></tr>", "pn", pn, "name", name, "manual", Request.handler(v, name).manual()));
            pn = "&";
        }
        return params;
    }
}

