/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io.read;

import java.beans.IntrospectionException;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.Options;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.betwixt.io.read.BeanCreationChain;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.MappingAction;
import org.apache.commons.betwixt.io.read.ReadConfiguration;
import org.apache.commons.betwixt.registry.PolymorphicReferenceResolver;
import org.apache.commons.betwixt.strategy.ActionMappingStrategy;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class ReadContext
extends Context {
    private ClassLoader classLoader;
    private ReadConfiguration readConfiguration;
    private ArrayStack elementMappingStack = new ArrayStack();
    private ArrayStack actionMappingStack = new ArrayStack();
    private ArrayStack objectStack = new ArrayStack();
    private ArrayStack descriptorStack = new ArrayStack();
    private ArrayStack updaterStack = new ArrayStack();
    private Class rootClass;
    private XMLIntrospector xmlIntrospector;
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$read$ReadContext;

    public ReadContext(Context context, ReadConfiguration readConfiguration) {
        super(context);
        this.readConfiguration = readConfiguration;
    }

    public ReadContext(BindingConfiguration bindingConfiguration, ReadConfiguration readConfiguration) {
        this(LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$read$ReadContext == null ? (class$org$apache$commons$betwixt$io$read$ReadContext = ReadContext.class$("org.apache.commons.betwixt.io.read.ReadContext")) : class$org$apache$commons$betwixt$io$read$ReadContext)), bindingConfiguration, readConfiguration);
    }

    public ReadContext(Log log, BindingConfiguration bindingConfiguration, ReadConfiguration readConfiguration) {
        super(null, log, bindingConfiguration);
        this.readConfiguration = readConfiguration;
    }

    public ReadContext(ReadContext readContext) {
        super(readContext);
        this.classLoader = readContext.classLoader;
        this.readConfiguration = readContext.readConfiguration;
    }

    public void putBean(String id, Object bean) {
        this.getIdMappingStrategy().setReference(this, bean, id);
    }

    public Object getBean(String id) {
        return this.getIdMappingStrategy().getReferenced(this, id);
    }

    public void clearBeans() {
        this.getIdMappingStrategy().reset();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public BeanCreationChain getBeanCreationChain() {
        return this.readConfiguration.getBeanCreationChain();
    }

    public ActionMappingStrategy getActionMappingStrategy() {
        return this.readConfiguration.getActionMappingStrategy();
    }

    public String popElement() {
        if (!this.descriptorStack.isEmpty()) {
            this.descriptorStack.pop();
        }
        if (!this.updaterStack.isEmpty()) {
            this.updaterStack.pop();
        }
        this.popOptions();
        Object top = null;
        if (!this.elementMappingStack.isEmpty() && (top = this.elementMappingStack.pop()) != null && !(top instanceof String)) {
            return this.popElement();
        }
        return (String)top;
    }

    public String getCurrentElement() {
        String result = null;
        int stackSize = this.elementMappingStack.size();
        for (int i = 0; i < stackSize; ++i) {
            Object mappedElement = this.elementMappingStack.peek(i);
            if (!(mappedElement instanceof String)) continue;
            result = (String)mappedElement;
            break;
        }
        return result;
    }

    public Class getLastMappedClass() {
        Class lastMapped = null;
        int size = this.elementMappingStack.size();
        for (int i = 0; i < size; ++i) {
            Object entry = this.elementMappingStack.peek(i);
            if (!(entry instanceof Class)) continue;
            lastMapped = (Class)entry;
            break;
        }
        return lastMapped;
    }

    private ElementDescriptor getParentDescriptor() throws IntrospectionException {
        ElementDescriptor result = null;
        if (this.descriptorStack.size() > 1) {
            result = (ElementDescriptor)this.descriptorStack.peek(1);
        }
        return result;
    }

    public void pushElement(String elementName) throws Exception {
        this.elementMappingStack.push((Object)elementName);
        ElementDescriptor nextDescriptor = null;
        if (this.elementMappingStack.size() == 1 && this.rootClass != null) {
            this.markClassMap(this.rootClass);
            XMLBeanInfo rootClassInfo = this.getXMLIntrospector().introspect(this.rootClass);
            nextDescriptor = rootClassInfo.getElementDescriptor();
        } else {
            ElementDescriptor currentDescriptor = this.getCurrentDescriptor();
            if (currentDescriptor != null) {
                nextDescriptor = currentDescriptor.getElementDescriptor(elementName);
            }
        }
        Updater updater = null;
        Options options = null;
        if (nextDescriptor != null) {
            updater = nextDescriptor.getUpdater();
            options = nextDescriptor.getOptions();
        }
        this.updaterStack.push((Object)updater);
        this.descriptorStack.push((Object)nextDescriptor);
        this.pushOptions(options);
    }

    public void markClassMap(Class mappedClazz) throws IntrospectionException {
        if (mappedClazz.isArray()) {
            mappedClazz = mappedClazz.getComponentType();
        }
        this.elementMappingStack.push(mappedClazz);
        XMLBeanInfo mappedClassInfo = this.getXMLIntrospector().introspect(mappedClazz);
        ElementDescriptor mappedElementDescriptor = mappedClassInfo.getElementDescriptor();
        this.descriptorStack.push((Object)mappedElementDescriptor);
        Updater updater = mappedElementDescriptor.getUpdater();
        this.updaterStack.push((Object)updater);
    }

    public MappingAction popMappingAction() {
        return (MappingAction)this.actionMappingStack.pop();
    }

    public void pushMappingAction(MappingAction mappingAction) {
        this.actionMappingStack.push((Object)mappingAction);
    }

    public MappingAction currentMappingAction() {
        if (this.actionMappingStack.size() == 0) {
            return null;
        }
        return (MappingAction)this.actionMappingStack.peek();
    }

    public Object getBean() {
        return this.objectStack.peek();
    }

    public void setBean(Object bean) {
    }

    public Object popBean() {
        return this.objectStack.pop();
    }

    public void pushBean(Object bean) {
        this.objectStack.push(bean);
    }

    public XMLIntrospector getXMLIntrospector() {
        if (this.xmlIntrospector == null) {
            this.xmlIntrospector = new XMLIntrospector();
        }
        return this.xmlIntrospector;
    }

    public void setXMLIntrospector(XMLIntrospector xmlIntrospector) {
        this.xmlIntrospector = xmlIntrospector;
    }

    public Class getRootClass() {
        return this.rootClass;
    }

    public void setRootClass(Class rootClass) {
        this.rootClass = rootClass;
    }

    public ElementDescriptor getCurrentDescriptor() throws Exception {
        ElementDescriptor result = null;
        if (!this.descriptorStack.empty()) {
            result = (ElementDescriptor)this.descriptorStack.peek();
        }
        return result;
    }

    public void populateAttributes(AttributeDescriptor[] attributeDescriptors, Attributes attributes) {
        Log log = this.getLog();
        if (attributeDescriptors != null) {
            int size = attributeDescriptors.length;
            for (int i = 0; i < size; ++i) {
                AttributeDescriptor attributeDescriptor = attributeDescriptors[i];
                String value = attributes.getValue(attributeDescriptor.getURI(), attributeDescriptor.getLocalName());
                if (value == null) {
                    value = attributes.getValue(attributeDescriptor.getQualifiedName());
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Attr URL:" + attributeDescriptor.getURI()));
                    log.trace((Object)("Attr LocalName:" + attributeDescriptor.getLocalName()));
                    log.trace((Object)value);
                }
                Updater updater = attributeDescriptor.getUpdater();
                log.trace((Object)updater);
                if (updater == null || value == null) continue;
                updater.update(this, value);
            }
        }
    }

    public void pushUpdater(Updater updater) {
        this.updaterStack.push((Object)updater);
    }

    public Updater popUpdater() {
        return (Updater)this.updaterStack.pop();
    }

    public Updater getCurrentUpdater() {
        Updater result = null;
        if (!this.updaterStack.empty() && (result = (Updater)this.updaterStack.peek()) == null && this.updaterStack.size() > 1) {
            result = (Updater)this.updaterStack.peek(1);
        }
        return result;
    }

    public Class resolvePolymorphicType(ElementMapping mapping) {
        Class result = null;
        Log log = this.getLog();
        try {
            ElementDescriptor parent;
            PolymorphicReferenceResolver resolver;
            ElementDescriptor currentDescriptor = this.getCurrentDescriptor();
            if (currentDescriptor != null && currentDescriptor.isPolymorphic() && (result = (resolver = this.getXMLIntrospector().getPolymorphicReferenceResolver()).resolveType(mapping, this)) == null && (parent = this.getParentDescriptor()) != null) {
                ElementDescriptor[] descriptors = parent.getElementDescriptors();
                ElementDescriptor originalDescriptor = mapping.getDescriptor();
                boolean resolved = false;
                for (int i = 0; i < descriptors.length; ++i) {
                    ElementDescriptor descriptor = descriptors[i];
                    if (!descriptor.isPolymorphic()) continue;
                    mapping.setDescriptor(descriptor);
                    result = resolver.resolveType(mapping, this);
                    if (result == null) continue;
                    resolved = true;
                    this.descriptorStack.pop();
                    this.popOptions();
                    this.descriptorStack.push((Object)descriptor);
                    this.pushOptions(descriptor.getOptions());
                    Updater originalUpdater = originalDescriptor.getUpdater();
                    Updater newUpdater = descriptor.getUpdater();
                    this.substituteUpdater(originalUpdater, newUpdater);
                    break;
                }
                if (resolved) {
                    log.debug((Object)"Resolved polymorphic type");
                } else {
                    log.debug((Object)"Failed to resolve polymorphic type");
                    mapping.setDescriptor(originalDescriptor);
                }
            }
        }
        catch (Exception e) {
            log.info((Object)"Failed to resolved polymorphic type");
            log.debug((Object)mapping, (Throwable)e);
        }
        return result;
    }

    private void substituteUpdater(Updater originalUpdater, Updater newUpdater) {
        if (!this.updaterStack.isEmpty()) {
            Updater updater = (Updater)this.updaterStack.pop();
            if (originalUpdater == null && updater == null) {
                this.updaterStack.push((Object)newUpdater);
            } else if (originalUpdater.equals(updater)) {
                this.updaterStack.push((Object)newUpdater);
            } else {
                this.substituteUpdater(originalUpdater, newUpdater);
                this.updaterStack.push((Object)updater);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

