/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.render.SourceSpansRenderer;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import com.google.caja.util.HandledAppendable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CajoledModule
extends AbstractParseTreeNode {
    private static final InputSource CAJOLED_OUTPUT_FILE_NAME = new InputSource(URI.create("file:///CAJOLED-OUTPUT"));

    @ParseTreeNode.ReflectiveCtor
    public CajoledModule(FilePosition pos, Void value, List<? extends ObjectConstructor> children) {
        this(pos, children.get(0));
        assert (children.size() == 1);
    }

    public CajoledModule(FilePosition pos, ObjectConstructor body) {
        super(pos, ObjectConstructor.class);
        this.createMutation().appendChild(body).execute();
    }

    public CajoledModule(ObjectConstructor body) {
        this(body.getFilePosition(), body);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (this.children().size() != 1) {
            throw new IllegalStateException("A CajoledModule may only have one child");
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    public ObjectConstructor getModuleBody() {
        return this.childrenAs(ObjectConstructor.class).get(0);
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
        return new JsPrettyPrinter(new Concatenator(out, exHandler));
    }

    @Override
    public void render(RenderContext rc) {
        this.renderModuleExpression((Expression)QuasiBuilder.substV("___.loadModule(@body)", "body", this.getModuleBody()), rc);
    }

    public void render(Expression callbackExpression, RenderContext rc) {
        if (callbackExpression == null) {
            this.render(rc);
        } else {
            this.renderModuleExpression((Expression)QuasiBuilder.substV("@callbackExpression(___.prepareModule(@body))", "callbackExpression", callbackExpression, "body", this.getModuleBody()), rc);
        }
    }

    private void renderModuleExpression(Expression expr, RenderContext rc) {
        Block block = new Block(FilePosition.UNKNOWN, Arrays.asList(new ExpressionStmt(FilePosition.UNKNOWN, expr)));
        block.render(rc);
    }

    public void renderWithDebugSymbols(Map<InputSource, CharSequence> originalSources, Appendable out, Callback<IOException> exHandler) {
        HandledAppendable hout = new HandledAppendable(exHandler, out);
        hout.append("{ ___.loadModule({\n");
        this.renderModuleBodyWithDebugSymbols(originalSources, out, exHandler);
        hout.append("}); }\n");
    }

    public void renderWithDebugSymbols(Expression callbackExpression, Map<InputSource, CharSequence> originalSources, Appendable out, Callback<IOException> exHandler) {
        HandledAppendable hout = new HandledAppendable(exHandler, out);
        hout.append("{");
        CajoledModule.renderNode(callbackExpression, out, exHandler);
        hout.append("(___.prepareModule({\n");
        this.renderModuleBodyWithDebugSymbols(originalSources, out, exHandler);
        hout.append("}));}\n");
    }

    private void renderModuleBodyWithDebugSymbols(Map<InputSource, CharSequence> originalSources, Appendable out, Callback<IOException> exHandler) {
        SourceSpansRenderer ssr = new SourceSpansRenderer(exHandler, CAJOLED_OUTPUT_FILE_NAME);
        RenderContext rc = new RenderContext(ssr);
        this.getModuleBody().getValue("instantiate").render(rc);
        ssr.noMoreTokens();
        ArrayList<String> abbreviatedOriginalFileNames = new ArrayList<String>();
        ArrayList<List<String>> originalFileContents = new ArrayList<List<String>>();
        for (InputSource is : ssr.getMessageContext().getInputSources()) {
            String sourceString = CajoledModule.charSequenceToString(originalSources.get(is));
            List<String> lines = Arrays.asList(sourceString.split("\r\n?|\n"));
            abbreviatedOriginalFileNames.add(ssr.getMessageContext().abbreviate(is));
            originalFileContents.add(lines);
        }
        CajoledModule.renderText(this.getModuleBody(), ssr.getProgramText(), ssr.getSourceLocationMap(), abbreviatedOriginalFileNames, originalFileContents, out, exHandler);
    }

    private static void renderText(ObjectConstructor moduleBody, String instantiateFunctionText, List<String> sourceLocationMap, List<String> abbreviatedOriginalFileNames, List<List<String>> originalFileContents, Appendable out, Callback<IOException> exHandler) {
        HandledAppendable hout = new HandledAppendable(exHandler, out);
        CajoledModule.renderNode(CajoledModule.stringToStringLiteral("instantiate"), out, exHandler);
        hout.append(":\n");
        hout.append(instantiateFunctionText);
        hout.append(",\n");
        List<? extends Expression> moduleBodyParts = moduleBody.children();
        int n = moduleBodyParts.size();
        for (int i = 0; i < n; i += 2) {
            String key = ((StringLiteral)moduleBodyParts.get(i)).getUnquotedValue();
            if ("instantiate".equals(key)) continue;
            CajoledModule.renderNode(CajoledModule.stringToStringLiteral(key), out, exHandler);
            hout.append(": ");
            CajoledModule.renderNode(moduleBodyParts.get(i + 1), out, exHandler);
            hout.append(",\n");
        }
        CajoledModule.renderNode(CajoledModule.stringToStringLiteral("sourceLocationMap"), out, exHandler);
        hout.append(": ");
        CajoledModule.renderNode(CajoledModule.stringListToContentNode(sourceLocationMap), out, exHandler);
        hout.append(",\n");
        CajoledModule.renderNode(CajoledModule.stringToStringLiteral("originalSource"), out, exHandler);
        hout.append(": ");
        CajoledModule.renderNode(CajoledModule.buildOriginalSourceNode(abbreviatedOriginalFileNames, originalFileContents), out, exHandler);
        hout.append("\n");
    }

    private static ParseTreeNode buildOriginalSourceNode(List<String> abbreviatedOriginalFileNames, List<List<String>> originalFileContents) {
        return QuasiBuilder.substV("({ @keys*: @values* })", "keys", CajoledModule.stringListToStringLiterals(abbreviatedOriginalFileNames), "values", CajoledModule.stringListListToMultipleContentNodes(originalFileContents));
    }

    private static ParseTreeNode stringListListToMultipleContentNodes(List<List<String>> contents) {
        ArrayList<ParseTreeNode> multipleContents = new ArrayList<ParseTreeNode>(contents.size());
        for (List<String> c : contents) {
            multipleContents.add(CajoledModule.stringListToContentNode(c));
        }
        return new ParseTreeNodeContainer(multipleContents);
    }

    private static ParseTreeNode stringListToContentNode(List<String> lines) {
        return QuasiBuilder.substV("  ({  type: 'content',  content: [ @stringLiterals* ]})", "stringLiterals", CajoledModule.stringListToStringLiterals(lines));
    }

    private static ParseTreeNode stringListToStringLiterals(List<String> strings) {
        ArrayList<ParseTreeNode> stringLiterals = new ArrayList<ParseTreeNode>(strings.size());
        for (String s : strings) {
            stringLiterals.add(CajoledModule.stringToStringLiteral(s));
        }
        return new ParseTreeNodeContainer(stringLiterals);
    }

    private static ParseTreeNode stringToStringLiteral(String s) {
        return StringLiteral.valueOf(FilePosition.UNKNOWN, s);
    }

    private static String charSequenceToString(CharSequence cs) {
        return cs instanceof String ? (String)cs : "" + cs;
    }

    private static void renderNode(ParseTreeNode node, Appendable out, Callback<IOException> exHandler) {
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(out, exHandler));
        node.render(new RenderContext(tc));
        tc.noMoreTokens();
    }
}

