/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Loop;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhileLoop
extends Loop {
    private Expression condition;
    private Statement body;

    @ParseTreeNode.ReflectiveCtor
    public WhileLoop(FilePosition pos, String label, List<? extends ParseTreeNode> children) {
        this(pos, label, (Expression)children.get(0), (Statement)children.get(1));
    }

    public WhileLoop(FilePosition pos, String label, Expression condition, Statement body) {
        super(pos, label, ParseTreeNode.class);
        this.createMutation().appendChild(condition).appendChild(body).execute();
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        this.condition = (Expression)this.children().get(0);
        this.body = (Statement)this.children().get(1);
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public Statement getBody() {
        return this.body;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        String label = this.getRenderedLabel(rc);
        if (null != label) {
            out.consume(label);
            out.consume(":");
        }
        out.consume("while");
        out.consume("(");
        this.condition.render(rc);
        out.consume(")");
        this.body.renderBlock(rc, false);
    }

    @Override
    public boolean hasHangingConditional() {
        return this.body.hasHangingConditional();
    }
}

