/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.thumbnail;

import java.io.File;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class ThumbnailPictureFactory
implements ThumbnailFactory {
    public Blob getThumbnail(DocumentModel doc, CoreSession session) throws ClientException {
        if (!doc.hasFacet("Picture")) {
            throw new ClientException("Document is not a picture");
        }
        MultiviewPicture mViewPicture = (MultiviewPicture)doc.getAdapter(MultiviewPicture.class);
        PictureView thumbnailView = mViewPicture.getView("Small");
        if (!(thumbnailView != null && thumbnailView.getBlob() != null || (thumbnailView = mViewPicture.getView("Thumbnail")) != null && thumbnailView.getBlob() != null)) {
            TypeInfo docType = (TypeInfo)doc.getAdapter(TypeInfo.class);
            return new FileBlob(FileUtils.getResourceFileFromContext((String)("nuxeo.war" + File.separator + docType.getBigIcon())));
        }
        return thumbnailView.getBlob();
    }

    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        return null;
    }
}

