/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodOverride
implements HttpExecuteInterceptor,
HttpRequestInitializer {
    private final EnumSet<HttpMethod> override;
    private final boolean overrideAllMethods;

    public MethodOverride() {
        this(false);
    }

    MethodOverride(boolean overrideAllMethods) {
        this(overrideAllMethods, EnumSet.noneOf(HttpMethod.class));
    }

    MethodOverride(boolean overrideAllMethods, EnumSet<HttpMethod> override) {
        this.overrideAllMethods = overrideAllMethods;
        this.override = override.clone();
    }

    @Deprecated
    public MethodOverride(EnumSet<HttpMethod> override) {
        this(false, override);
    }

    public void initialize(HttpRequest request) {
        request.setInterceptor((HttpExecuteInterceptor)this);
    }

    public void intercept(HttpRequest request) throws IOException {
        if (this.overrideThisMethod(request)) {
            String requestMethod = request.getRequestMethod();
            request.setRequestMethod("POST");
            request.getHeaders().set("X-HTTP-Method-Override", (Object)requestMethod);
            if (request.getContent() == null) {
                request.setContent((HttpContent)new EmptyContent());
            }
        }
    }

    private boolean overrideThisMethod(HttpRequest request) throws IOException {
        String requestMethod = request.getRequestMethod();
        boolean supportsMethod = request.getTransport().supportsMethod(requestMethod);
        if (requestMethod.equals("GET") || requestMethod.equals("POST")) {
            Preconditions.checkArgument((boolean)supportsMethod);
            return false;
        }
        if (this.overrideAllMethods || this.override.contains(request.getMethod())) {
            return true;
        }
        if (requestMethod.equals("PATCH")) {
            return !request.getTransport().supportsPatch();
        }
        if (requestMethod.equals("HEAD")) {
            return !request.getTransport().supportsHead();
        }
        return !supportsMethod;
    }

    public static final class Builder {
        private boolean overrideAllMethods;

        public MethodOverride build() {
            return new MethodOverride(this.overrideAllMethods);
        }

        public boolean getOverrideAllMethods() {
            return this.overrideAllMethods;
        }

        public Builder setOverrideAllMethods(boolean overrideAllMethods) {
            this.overrideAllMethods = overrideAllMethods;
            return this;
        }
    }
}

