/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.api.AnnotationManager;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QueryResult;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;

public class AnnotationQuery {
    public static final String BASE_QUERY = "SELECT ?uri SELECT {}";
    private final AnnotationManager manager = new AnnotationManager();

    public List<Annotation> getAnnotationsForURIs(List<URI> uris, Graph graph) throws AnnotationException {
        return this.getAnnotationsForURIs(uris, graph, Collections.emptyMap());
    }

    public List<Annotation> getAnnotationsForURIs(List<URI> uris, Graph graph, Map<String, String> filters) throws AnnotationException {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        String baseQuery = " SELECT ?s ?p ?o WHERE { ?s ?p ?o . }";
        for (URI uri : uris) {
            StringBuilder query = new StringBuilder(" SELECT ?s ?p ?o WHERE { ?s ?p ?o . }");
            query.insert(query.lastIndexOf("}"), " ?s <http://www.w3.org/2000/10/annotation-ns#annotates> <" + uri.toString() + "> . ");
            if (filters != null) {
                for (Map.Entry<String, String> entry : filters.entrySet()) {
                    query.insert(query.lastIndexOf("}"), " ?s <" + entry.getKey() + "> <" + entry.getValue() + "> . ");
                }
            }
            QueryResult results = graph.query(query.toString(), "sparql", null);
            HashMap<String, ArrayList<StatementImpl>> mapann = new HashMap<String, ArrayList<StatementImpl>>();
            for (Map map : results.getResults()) {
                Node subject = (Node)map.get("s");
                Node predicate = (Node)map.get("p");
                Node object = (Node)map.get("o");
                ArrayList<StatementImpl> statements = (ArrayList<StatementImpl>)mapann.get(subject.toString());
                if (statements == null) {
                    statements = new ArrayList<StatementImpl>();
                    mapann.put(subject.toString(), statements);
                }
                statements.add(new StatementImpl(subject, predicate, object));
            }
            for (List stats : mapann.values()) {
                annotations.add(this.manager.getAnnotation(stats));
            }
        }
        return annotations;
    }
}

