/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.servlet;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.config.Configuration;
import org.jsecurity.config.ConfigurationException;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.util.ClassUtils;
import org.jsecurity.util.LifecycleUtils;
import org.jsecurity.util.StringUtils;
import org.jsecurity.util.ThreadContext;
import org.jsecurity.web.DefaultWebSecurityManager;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.config.IniWebConfiguration;
import org.jsecurity.web.config.WebConfiguration;
import org.jsecurity.web.servlet.JSecurityHttpServletRequest;
import org.jsecurity.web.servlet.JSecurityHttpServletResponse;
import org.jsecurity.web.servlet.OncePerRequestFilter;

public class JSecurityFilter
extends OncePerRequestFilter {
    public static final String SECURITY_MANAGER_CONTEXT_KEY = SecurityManager.class.getName() + "_SERVLET_CONTEXT_KEY";
    public static final String CONFIG_CLASS_NAME_INIT_PARAM_NAME = "configClassName";
    public static final String CONFIG_INIT_PARAM_NAME = "config";
    public static final String CONFIG_URL_INIT_PARAM_NAME = "configUrl";
    private static final Log log = LogFactory.getLog(JSecurityFilter.class);
    protected String config;
    protected String configUrl;
    protected String configClassName = IniWebConfiguration.class.getName();
    protected WebConfiguration configuration;
    protected SecurityManager securityManager;

    public WebConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(WebConfiguration configuration) {
        this.configuration = configuration;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    protected void setSecurityManager(SecurityManager sm) {
        this.securityManager = sm;
    }

    protected void onFilterConfigSet() throws Exception {
        this.applyInitParams();
        WebConfiguration config = this.configure();
        this.setConfiguration(config);
        SecurityManager sm = this.ensureSecurityManager(config);
        this.setSecurityManager(sm);
    }

    protected SecurityManager ensureSecurityManager(Configuration config) {
        SecurityManager sm = config.getSecurityManager();
        if (sm == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Configuration instance [" + config + "] did not provide a SecurityManager.  No config " + "specified?  Defaulting to a " + DefaultWebSecurityManager.class.getName() + " instance..."));
            }
            sm = new DefaultWebSecurityManager();
        }
        return sm;
    }

    protected void applyInitParams() {
        FilterConfig config = this.getFilterConfig();
        String configCN = StringUtils.clean(config.getInitParameter(CONFIG_CLASS_NAME_INIT_PARAM_NAME));
        if (configCN != null) {
            if (ClassUtils.isAvailable(configCN)) {
                this.configClassName = configCN;
            } else {
                String msg = "configClassName fully qualified class name value [" + configCN + "] is not " + "available in the classpath.  Please ensure you have typed it correctly and the " + "corresponding class or jar is in the classpath.";
                throw new ConfigurationException(msg);
            }
        }
        this.config = StringUtils.clean(config.getInitParameter(CONFIG_INIT_PARAM_NAME));
        this.configUrl = StringUtils.clean(config.getInitParameter(CONFIG_URL_INIT_PARAM_NAME));
    }

    protected WebConfiguration configure() {
        WebConfiguration conf = (WebConfiguration)ClassUtils.newInstance(this.configClassName);
        this.applyFilterConfig(conf);
        this.applyUrlConfig(conf);
        this.applyEmbeddedConfig(conf);
        LifecycleUtils.init(conf);
        return conf;
    }

    protected void applyFilterConfig(WebConfiguration conf) {
        block4: {
            if (log.isDebugEnabled()) {
                String msg = "Attempting to inject the FilterConfig (using 'setFilterConfig' method) into the instantiated WebConfiguration for any wrapped Filter initialization...";
                log.debug((Object)msg);
            }
            try {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)conf, (String)"filterConfig");
                if (pd != null) {
                    PropertyUtils.setProperty((Object)conf, (String)"filterConfig", (Object)this.getFilterConfig());
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Error setting FilterConfig on WebConfiguration instance.", (Throwable)e);
            }
        }
    }

    protected void applyEmbeddedConfig(WebConfiguration conf) {
        if (this.config != null) {
            try {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)conf, (String)CONFIG_INIT_PARAM_NAME);
                if (pd == null) {
                    String msg = "The 'config' filter param was specified, but there is no 'setConfig(String)' method on the Configuration instance [" + conf + "].  If you do " + "not require the 'config' filter param, please comment it out, or if you do need it, " + "please ensure your Configuration instance has a 'setConfig(String)' method to receive it.";
                    throw new ConfigurationException(msg);
                }
                PropertyUtils.setProperty((Object)conf, (String)CONFIG_INIT_PARAM_NAME, (Object)this.config);
            }
            catch (Exception e) {
                String msg = "There was an error setting the 'config' property of the Configuration object.";
                throw new ConfigurationException(msg, e);
            }
        }
    }

    protected void applyUrlConfig(WebConfiguration conf) {
        if (this.configUrl != null) {
            try {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)conf, (String)CONFIG_URL_INIT_PARAM_NAME);
                if (pd == null) {
                    String msg = "The 'configUrl' filter param was specified, but there is no 'setConfigUrl(String)' method on the Configuration instance [" + conf + "].  If you do " + "not require the 'configUrl' filter param, please comment it out, or if you do need it, " + "please ensure your Configuration instance has a 'setConfigUrl(String)' method to receive it.";
                    throw new ConfigurationException(msg);
                }
                PropertyUtils.setProperty((Object)conf, (String)CONFIG_URL_INIT_PARAM_NAME, (Object)this.configUrl);
            }
            catch (Exception e) {
                String msg = "There was an error setting the 'configUrl' property of the Configuration object.";
                throw new ConfigurationException(msg, e);
            }
        }
    }

    protected boolean isHttpSessions() {
        SecurityManager secMgr = this.getSecurityManager();
        if (secMgr instanceof DefaultWebSecurityManager) {
            return ((DefaultWebSecurityManager)secMgr).isHttpSessionMode();
        }
        return true;
    }

    protected InetAddress getInetAddress(ServletRequest request) {
        return WebUtils.getInetAddress(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain origChain) throws ServletException, IOException {
        Object request = (HttpServletRequest)servletRequest;
        Object response = (HttpServletResponse)servletResponse;
        ThreadContext.bind(this.getInetAddress((ServletRequest)request));
        boolean httpSessions = this.isHttpSessions();
        request = new JSecurityHttpServletRequest((HttpServletRequest)request, this.getServletContext(), httpSessions);
        if (!httpSessions) {
            response = new JSecurityHttpServletResponse((HttpServletResponse)response, this.getServletContext(), (JSecurityHttpServletRequest)((Object)request));
        }
        WebUtils.bind((ServletRequest)request);
        WebUtils.bind((ServletResponse)response);
        ThreadContext.bind(this.getSecurityManager());
        ThreadContext.bind(this.getSecurityManager().getSubject());
        FilterChain chain = this.getConfiguration().getChain((ServletRequest)request, (ServletResponse)response, origChain);
        if (chain == null) {
            chain = origChain;
            if (log.isTraceEnabled()) {
                log.trace((Object)"No security filter chain configured for the current request.  Using default.");
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)" Using configured filter chain for the current request.");
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            ThreadContext.unbindSubject();
            ThreadContext.unbindSecurityManager();
            WebUtils.unbindServletResponse();
            WebUtils.unbindServletRequest();
            ThreadContext.unbindInetAddress();
        }
    }

    public void destroy() {
        LifecycleUtils.destroy(this.getConfiguration());
    }
}

