/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.docusign.core.automation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nuxeo.docusign.core.service.DocuSignService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="SendToDocuSign", category="Services", label="DocuSign: Send To DocuSign", description="Send the document to DocuSign for electronic signature.Warning: Document(s) is/are not saved by the oeration, caller is reponsible of saving it/them (if this is not done, the document will not have the 'Docusign' facet and its schema, retrieval of the signed blob will fail")
public class DSSendToDocuSignOp {
    public static final String ID = "SendToDocuSign";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Context
    protected DocuSignService service;
    @Param(name="signerEmails", description="A StringList of email addresses", required=true)
    protected StringList signerEmails;
    @Param(name="subject", description="The subject of the email sent to the signers", required=true)
    protected String subject;
    @Param(name="contextVariable", description="The name of the context variable where the envelope ID will be stored", required=true)
    protected String contextVariable;
    @Param(name="customFields", description="Custom Fields to be added to the envelope", required=false)
    protected Properties customFields = new Properties();
    @Param(name="callbackUrl", description="The callback URL DocuSign will use for this envelope", required=false)
    protected String callbackUrl;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        DocumentModelListImpl docs = new DocumentModelListImpl();
        docs.add((Object)doc);
        String envelopeId = this.service.send(this.session, (DocumentModelList)docs, this.subject, (List<String>)this.signerEmails, (Map<String, String>)this.customFields, this.callbackUrl);
        this.ctx.put(this.contextVariable, (Object)envelopeId);
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        String envelopeId = this.service.send(this.session, docs, this.subject, (List<String>)this.signerEmails, (Map<String, String>)this.customFields, this.callbackUrl);
        this.ctx.put(this.contextVariable, (Object)envelopeId);
        return docs;
    }

    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        String envelopeId = this.service.send(this.session, Collections.singletonList(blob), this.subject, (List<String>)this.signerEmails, (Map<String, String>)this.customFields, this.callbackUrl);
        this.ctx.put(this.contextVariable, (Object)envelopeId);
        return blob;
    }

    @OperationMethod
    public BlobList run(BlobList blobs) throws Exception {
        String envelopeId = this.service.send(this.session, (List<Blob>)blobs, this.subject, (List<String>)this.signerEmails, (Map<String, String>)this.customFields, this.callbackUrl);
        this.ctx.put(this.contextVariable, (Object)envelopeId);
        return blobs;
    }
}

