/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.docusign.core.service.auth;

import com.docusign.esign.client.ApiClient;
import com.google.api.client.auth.oauth2.Credential;
import org.nuxeo.docusign.core.service.DocuSignCredentialFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;

public class Oauth2CredentialFactory
implements DocuSignCredentialFactory {
    @Override
    public void setCredential(ApiClient client, String username) {
        OAuth2ServiceProviderRegistry registry = (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
        OAuth2ServiceProvider provider = registry.getProvider("docusign");
        if (provider == null) {
            throw new NuxeoException("Cannot find DocuSign Oauth2 provider");
        }
        Credential credential = provider.loadCredential(username);
        if (credential == null) {
            throw new NuxeoException("Cannot find DocuSign Credential for " + username);
        }
        client.addDefaultHeader("Authorization", "Bearer " + credential.getAccessToken());
    }
}

