/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.docusign.core.worker;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.docusign.core.callback.DSEvent;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DSCallbackWorker
extends AbstractWork {
    private static final Logger log = LogManager.getLogger(DSCallbackWorker.class);
    private DSEvent event;
    private String chainName;

    public DSCallbackWorker(DSEvent event, String chainName) {
        this.event = event;
        this.chainName = chainName;
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("inProgress");
        if (!TransactionHelper.isTransactionActive()) {
            this.startTransaction();
        }
        this.openSystemSession();
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext octx = new OperationContext();
        octx.setCoreSession(this.session);
        octx.put("event", (Object)this.event);
        OperationChain chain = new OperationChain("DocuSignCallbackProcessingChain");
        chain.add(this.chainName).set("envelopeId", (Object)this.event.getEnveloppeId()).set("envelopeStatus", (Object)this.event.getEnveloppeStatus()).set("envelopeSender", (Object)this.event.getSender()).set("customFields", (Object)new Properties(this.event.getCustomfields()));
        try {
            as.run(octx, chain);
        }
        catch (OperationException e) {
            throw new NuxeoException((Throwable)e);
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.closeSession();
        this.setStatus("Done");
    }

    public String getTitle() {
        return "DocusignCallbackWorker";
    }
}

