/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.BillingInvoiceItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains information about a billing invoice.")
public class BillingInvoice {
    @JsonProperty(value="amount")
    private String amount = null;
    @JsonProperty(value="balance")
    private String balance = null;
    @JsonProperty(value="dueDate")
    private String dueDate = null;
    @JsonProperty(value="invoiceId")
    private String invoiceId = null;
    @JsonProperty(value="invoiceItems")
    private List<BillingInvoiceItem> invoiceItems = new ArrayList<BillingInvoiceItem>();
    @JsonProperty(value="invoiceNumber")
    private String invoiceNumber = null;
    @JsonProperty(value="invoiceUri")
    private String invoiceUri = null;
    @JsonProperty(value="nonTaxableAmount")
    private String nonTaxableAmount = null;
    @JsonProperty(value="pdfAvailable")
    private String pdfAvailable = null;
    @JsonProperty(value="taxableAmount")
    private String taxableAmount = null;

    public BillingInvoice amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public BillingInvoice balance(String balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getBalance() {
        return this.balance;
    }

    public void setBalance(String balance) {
        this.balance = balance;
    }

    public BillingInvoice dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public BillingInvoice invoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public BillingInvoice invoiceItems(List<BillingInvoiceItem> invoiceItems) {
        this.invoiceItems = invoiceItems;
        return this;
    }

    public BillingInvoice addInvoiceItemsItem(BillingInvoiceItem invoiceItemsItem) {
        this.invoiceItems.add(invoiceItemsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public List<BillingInvoiceItem> getInvoiceItems() {
        return this.invoiceItems;
    }

    public void setInvoiceItems(List<BillingInvoiceItem> invoiceItems) {
        this.invoiceItems = invoiceItems;
    }

    public BillingInvoice invoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public BillingInvoice invoiceUri(String invoiceUri) {
        this.invoiceUri = invoiceUri;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a URI for an endpoint that you can use to retrieve invoice information.")
    public String getInvoiceUri() {
        return this.invoiceUri;
    }

    public void setInvoiceUri(String invoiceUri) {
        this.invoiceUri = invoiceUri;
    }

    public BillingInvoice nonTaxableAmount(String nonTaxableAmount) {
        this.nonTaxableAmount = nonTaxableAmount;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getNonTaxableAmount() {
        return this.nonTaxableAmount;
    }

    public void setNonTaxableAmount(String nonTaxableAmount) {
        this.nonTaxableAmount = nonTaxableAmount;
    }

    public BillingInvoice pdfAvailable(String pdfAvailable) {
        this.pdfAvailable = pdfAvailable;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPdfAvailable() {
        return this.pdfAvailable;
    }

    public void setPdfAvailable(String pdfAvailable) {
        this.pdfAvailable = pdfAvailable;
    }

    public BillingInvoice taxableAmount(String taxableAmount) {
        this.taxableAmount = taxableAmount;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getTaxableAmount() {
        return this.taxableAmount;
    }

    public void setTaxableAmount(String taxableAmount) {
        this.taxableAmount = taxableAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingInvoice billingInvoice = (BillingInvoice)o;
        return Objects.equals(this.amount, billingInvoice.amount) && Objects.equals(this.balance, billingInvoice.balance) && Objects.equals(this.dueDate, billingInvoice.dueDate) && Objects.equals(this.invoiceId, billingInvoice.invoiceId) && Objects.equals(this.invoiceItems, billingInvoice.invoiceItems) && Objects.equals(this.invoiceNumber, billingInvoice.invoiceNumber) && Objects.equals(this.invoiceUri, billingInvoice.invoiceUri) && Objects.equals(this.nonTaxableAmount, billingInvoice.nonTaxableAmount) && Objects.equals(this.pdfAvailable, billingInvoice.pdfAvailable) && Objects.equals(this.taxableAmount, billingInvoice.taxableAmount);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.balance, this.dueDate, this.invoiceId, this.invoiceItems, this.invoiceNumber, this.invoiceUri, this.nonTaxableAmount, this.pdfAvailable, this.taxableAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingInvoice {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    invoiceId: ").append(this.toIndentedString(this.invoiceId)).append("\n");
        sb.append("    invoiceItems: ").append(this.toIndentedString(this.invoiceItems)).append("\n");
        sb.append("    invoiceNumber: ").append(this.toIndentedString(this.invoiceNumber)).append("\n");
        sb.append("    invoiceUri: ").append(this.toIndentedString(this.invoiceUri)).append("\n");
        sb.append("    nonTaxableAmount: ").append(this.toIndentedString(this.nonTaxableAmount)).append("\n");
        sb.append("    pdfAvailable: ").append(this.toIndentedString(this.pdfAvailable)).append("\n");
        sb.append("    taxableAmount: ").append(this.toIndentedString(this.taxableAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

