/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.NameValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LoginAccount {
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="accountIdGuid")
    private String accountIdGuid = null;
    @JsonProperty(value="baseUrl")
    private String baseUrl = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="isDefault")
    private String isDefault = null;
    @JsonProperty(value="loginAccountSettings")
    private List<NameValue> loginAccountSettings = new ArrayList<NameValue>();
    @JsonProperty(value="loginUserSettings")
    private List<NameValue> loginUserSettings = new ArrayList<NameValue>();
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="siteDescription")
    private String siteDescription = null;
    @JsonProperty(value="userId")
    private String userId = null;
    @JsonProperty(value="userName")
    private String userName = null;

    public LoginAccount accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="null", value="The account ID associated with the envelope.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public LoginAccount accountIdGuid(String accountIdGuid) {
        this.accountIdGuid = accountIdGuid;
        return this;
    }

    @ApiModelProperty(example="null", value="The GUID associated with the account ID.")
    public String getAccountIdGuid() {
        return this.accountIdGuid;
    }

    public void setAccountIdGuid(String accountIdGuid) {
        this.accountIdGuid = accountIdGuid;
    }

    public LoginAccount baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL that should be used for successive calls to this account. It includes the protocal (https), the DocuSign server where the account is located, and the account number. Use this Url to make API calls against this account. Many of the API calls provide Uri's that are relative to this baseUrl.")
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public LoginAccount email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="null", value="The email address for the user.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public LoginAccount isDefault(String isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @ApiModelProperty(example="null", value="This value is true if this is the default account for the user, otherwise false is returned.")
    public String getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(String isDefault) {
        this.isDefault = isDefault;
    }

    public LoginAccount loginAccountSettings(List<NameValue> loginAccountSettings) {
        this.loginAccountSettings = loginAccountSettings;
        return this;
    }

    public LoginAccount addLoginAccountSettingsItem(NameValue loginAccountSettingsItem) {
        this.loginAccountSettings.add(loginAccountSettingsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A list of settings on the acccount that indicate what features are available.")
    public List<NameValue> getLoginAccountSettings() {
        return this.loginAccountSettings;
    }

    public void setLoginAccountSettings(List<NameValue> loginAccountSettings) {
        this.loginAccountSettings = loginAccountSettings;
    }

    public LoginAccount loginUserSettings(List<NameValue> loginUserSettings) {
        this.loginUserSettings = loginUserSettings;
        return this;
    }

    public LoginAccount addLoginUserSettingsItem(NameValue loginUserSettingsItem) {
        this.loginUserSettings.add(loginUserSettingsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A list of user-level settings that indicate what user-specific features are available.")
    public List<NameValue> getLoginUserSettings() {
        return this.loginUserSettings;
    }

    public void setLoginUserSettings(List<NameValue> loginUserSettings) {
        this.loginUserSettings = loginUserSettings;
    }

    public LoginAccount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name associated with the account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LoginAccount siteDescription(String siteDescription) {
        this.siteDescription = siteDescription;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional descirption of the site that hosts the account.")
    public String getSiteDescription() {
        return this.siteDescription;
    }

    public void setSiteDescription(String siteDescription) {
        this.siteDescription = siteDescription;
    }

    public LoginAccount userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public LoginAccount userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of this user as defined by the account.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginAccount loginAccount = (LoginAccount)o;
        return Objects.equals(this.accountId, loginAccount.accountId) && Objects.equals(this.accountIdGuid, loginAccount.accountIdGuid) && Objects.equals(this.baseUrl, loginAccount.baseUrl) && Objects.equals(this.email, loginAccount.email) && Objects.equals(this.isDefault, loginAccount.isDefault) && Objects.equals(this.loginAccountSettings, loginAccount.loginAccountSettings) && Objects.equals(this.loginUserSettings, loginAccount.loginUserSettings) && Objects.equals(this.name, loginAccount.name) && Objects.equals(this.siteDescription, loginAccount.siteDescription) && Objects.equals(this.userId, loginAccount.userId) && Objects.equals(this.userName, loginAccount.userName);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountIdGuid, this.baseUrl, this.email, this.isDefault, this.loginAccountSettings, this.loginUserSettings, this.name, this.siteDescription, this.userId, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoginAccount {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountIdGuid: ").append(this.toIndentedString(this.accountIdGuid)).append("\n");
        sb.append("    baseUrl: ").append(this.toIndentedString(this.baseUrl)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    loginAccountSettings: ").append(this.toIndentedString(this.loginAccountSettings)).append("\n");
        sb.append("    loginUserSettings: ").append(this.toIndentedString(this.loginUserSettings)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    siteDescription: ").append(this.toIndentedString(this.siteDescription)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

