/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.docusign.core.callback;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.nuxeo.docusign.core.callback.DSEvent;
import org.nuxeo.ecm.core.api.NuxeoException;

public class DSEventParser {
    public DSEvent parse(InputStream in) {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(in);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("edx", "http://www.docusign.net/API/3.0");
            Dom4jXPath xpath = new Dom4jXPath("//edx:EnvelopeStatus/edx:EnvelopeID");
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
            List nodes = xpath.selectNodes((Object)doc);
            String envelopeId = ((Node)nodes.get(0)).getText();
            xpath = new Dom4jXPath("//edx:EnvelopeStatus/edx:Status");
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
            nodes = xpath.selectNodes((Object)doc);
            String envelopeStatus = ((Node)nodes.get(0)).getText();
            String sender = null;
            HashMap<String, String> customFields = new HashMap<String, String>();
            xpath = new Dom4jXPath("//edx:EnvelopeStatus/edx:CustomFields/edx:CustomField/edx:Name");
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
            List names = xpath.selectNodes((Object)doc);
            xpath = new Dom4jXPath("//edx:EnvelopeStatus/edx:CustomFields/edx:CustomField/edx:Value");
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
            List values = xpath.selectNodes((Object)doc);
            for (int i = 0; i < names.size(); ++i) {
                if ("nuxeoUsername".equals(((Node)names.get(i)).getText())) {
                    sender = ((Node)values.get(i)).getText();
                    continue;
                }
                customFields.put(((Node)names.get(i)).getText(), ((Node)values.get(i)).getText());
            }
            return new DSEvent(envelopeId, envelopeStatus, doc.asXML(), sender, customFields);
        }
        catch (DocumentException | JaxenException e) {
            throw new NuxeoException(e);
        }
    }
}

