/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.docusign.core.service;

import com.docusign.esign.api.AuthenticationApi;
import com.docusign.esign.api.EnvelopesApi;
import com.docusign.esign.client.ApiClient;
import com.docusign.esign.model.CustomFields;
import com.docusign.esign.model.Document;
import com.docusign.esign.model.EnvelopeDefinition;
import com.docusign.esign.model.EnvelopeDocument;
import com.docusign.esign.model.EnvelopeDocumentsResult;
import com.docusign.esign.model.EnvelopeEvent;
import com.docusign.esign.model.EnvelopeSummary;
import com.docusign.esign.model.EventNotification;
import com.docusign.esign.model.LoginAccount;
import com.docusign.esign.model.LoginInformation;
import com.docusign.esign.model.Recipients;
import com.docusign.esign.model.Signer;
import com.docusign.esign.model.TextCustomField;
import com.google.api.client.util.Base64;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.docusign.core.adapter.DSAdapter;
import org.nuxeo.docusign.core.callback.DSEvent;
import org.nuxeo.docusign.core.callback.DSEventParser;
import org.nuxeo.docusign.core.service.DocuSignDescriptor;
import org.nuxeo.docusign.core.service.DocuSignService;
import org.nuxeo.docusign.core.worker.DSCallbackWorker;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocuSignServiceImpl
extends DefaultComponent
implements DocuSignService {
    private static final Logger log = LogManager.getLogger(DocuSignServiceImpl.class);
    protected static final String CONFIG_EXT_POINT = "configuration";
    protected DocuSignDescriptor config = null;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EXT_POINT.equals(extensionPoint)) {
            this.config = (DocuSignDescriptor)contribution;
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public String send(CoreSession session, List<Blob> blobs, String subject, List<String> signerEmails, Map<String, String> customFields, String callbackUrl) throws Exception {
        ApiClient client = this.getClient(session);
        AuthenticationApi authApi = new AuthenticationApi(client);
        LoginInformation loginInfo = authApi.login();
        String accountId = ((LoginAccount)loginInfo.getLoginAccounts().get(0)).getAccountId();
        EnvelopeDefinition envDef = new EnvelopeDefinition();
        envDef.setEmailSubject(subject);
        ArrayList<Object> signers = new ArrayList<Object>();
        int i = 1;
        for (String email : signerEmails) {
            Signer signer = new Signer();
            signer.setName(email);
            signer.setEmail(email);
            signer.setRecipientId("" + i++);
            signers.add(signer);
        }
        Recipients recipients = new Recipients();
        recipients.setSigners(signers);
        envDef.setRecipients(recipients);
        ArrayList<Document> documents = new ArrayList<Document>();
        int i2 = 1;
        for (Blob blob : blobs) {
            String string = Base64.encodeBase64String((byte[])IOUtils.toByteArray((InputStream)blob.getStream()));
            documents.add(new Document().name(blob.getFilename()).documentId("" + i2++).documentBase64(string).fileExtension(FilenameUtils.getExtension((String)blob.getFilename())));
        }
        envDef.setDocuments(documents);
        TextCustomField usernameField = new TextCustomField();
        usernameField.setName("nuxeoUsername");
        usernameField.setValue(session.getPrincipal().getName());
        ArrayList<TextCustomField> customFieldList = new ArrayList<TextCustomField>();
        customFieldList.add(usernameField);
        for (Map.Entry<String, String> entry : customFields.entrySet()) {
            TextCustomField customField = new TextCustomField().name(entry.getKey()).value(entry.getValue());
            customFieldList.add(customField);
        }
        CustomFields customFields2 = new CustomFields();
        customFields2.setTextCustomFields(customFieldList);
        envDef.setCustomFields(customFields2);
        envDef.setStatus("sent");
        if (callbackUrl != null && callbackUrl.length() > 0) {
            EventNotification eventNotification = new EventNotification();
            eventNotification.setUrl(callbackUrl);
            eventNotification.setEnvelopeEvents(Collections.singletonList(new EnvelopeEvent().envelopeEventStatusCode("completed").includeDocuments("false")));
            eventNotification.setLoggingEnabled("true");
            eventNotification.setRequireAcknowledgment("true");
            envDef.setEventNotification(eventNotification);
        }
        EnvelopesApi envelopesApi = new EnvelopesApi(client);
        EnvelopeSummary envelopeSummary = envelopesApi.createEnvelope(accountId, envDef);
        return envelopeSummary.getEnvelopeId();
    }

    @Override
    public String send(CoreSession session, DocumentModelList docs, String subject, List<String> signerEmails, Map<String, String> customFields, String callbackUrl) throws Exception {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (DocumentModel doc : docs) {
            Blob blob = (Blob)doc.getPropertyValue("file:content");
            if (blob == null) continue;
            blobs.add(blob);
        }
        String envelopeId = this.send(session, blobs, subject, signerEmails, customFields, callbackUrl);
        int position = 1;
        for (DocumentModel doc : docs) {
            Blob blob = (Blob)doc.getPropertyValue("file:content");
            if (blob == null) continue;
            doc.addFacet("Docusign");
            DSAdapter adapter = (DSAdapter)doc.getAdapter(DSAdapter.class);
            adapter.setEnvelopeId(envelopeId);
            adapter.setEnvelopePosition(position++);
            adapter.setSender(session.getPrincipal().getName());
        }
        return envelopeId;
    }

    @Override
    public List<Blob> getSignedBlobs(CoreSession session, String envelopeId) throws Exception {
        ApiClient client = this.getClient(session);
        EnvelopesApi envelopesApi = new EnvelopesApi(client);
        AuthenticationApi authApi = new AuthenticationApi(client);
        LoginInformation loginInfo = authApi.login();
        String accountId = ((LoginAccount)loginInfo.getLoginAccounts().get(0)).getAccountId();
        EnvelopeDocumentsResult envelopeDocs = envelopesApi.listDocuments(accountId, envelopeId);
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (EnvelopeDocument doc : envelopeDocs.getEnvelopeDocuments()) {
            byte[] bytes = envelopesApi.getDocument(accountId, envelopeId, doc.getDocumentId());
            ByteArrayBlob blob = new ByteArrayBlob(bytes, "application/pdf");
            blob.setFilename(doc.getDocumentId());
            blobs.add((Blob)blob);
        }
        return blobs;
    }

    @Override
    public DocumentModelList updateDocuments(CoreSession session, String envelopeId) throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)session);
        PageProvider pp = pps.getPageProvider("DocuSignEnvelopeDoc", null, Long.valueOf(50L), Long.valueOf(0L), props, new Object[]{envelopeId});
        List docs = pp.getCurrentPage();
        if (docs.size() == 0) {
            return new DocumentModelListImpl();
        }
        List<Blob> blobs = this.getSignedBlobs(session, envelopeId);
        if (blobs.size() == 0) {
            throw new NuxeoException("Could noy fetch blobs for envelopeId " + envelopeId);
        }
        HashMap<String, Blob> blobsByName = new HashMap<String, Blob>();
        for (Blob blob : blobs) {
            blobsByName.put(blob.getFilename(), blob);
        }
        for (DocumentModel doc : docs) {
            Blob original = (Blob)doc.getPropertyValue("file:content");
            String originalFilename = original.getFilename();
            String targetFilename = FilenameUtils.removeExtension((String)originalFilename) + ".pdf";
            DSAdapter adapter = (DSAdapter)doc.getAdapter(DSAdapter.class);
            long position = adapter.getEnvelopePosition();
            Blob blob = (Blob)blobsByName.get("" + position);
            blob.setFilename(targetFilename);
            adapter.setSignedBlob(blob);
        }
        return new DocumentModelListImpl(docs);
    }

    @Override
    public void handleCallbackEvent(InputStream stream, String chainName) {
        DSEventParser parser = new DSEventParser();
        DSEvent event = parser.parse(stream);
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        if (chainName == null) {
            chainName = this.config.getDefaultCallbackChain();
        }
        wm.schedule((Work)new DSCallbackWorker(event, chainName));
    }

    private ApiClient getClient(CoreSession session) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(this.config.getBasePath());
        this.config.getCredentialFactoryClass().setCredential(apiClient, session.getPrincipal().getName());
        return apiClient;
    }
}

