/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.io.Serializable;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.nuxeo.drive.adapter.FileSystemItem;

public class FileSystemItemChange
implements Serializable {
    private static final long serialVersionUID = -5697869523880291618L;
    protected String repositoryId;
    protected String eventId;
    protected Long eventDate;
    protected String docUuid;
    protected FileSystemItem fileSystemItem;
    protected String fileSystemItemId;
    protected String fileSystemItemName;

    public FileSystemItemChange() {
    }

    public FileSystemItemChange(String eventId, long eventDate, String repositoryId, String docUuid, String fileSystemItemId, String fileSystemItemName) {
        this.eventId = eventId;
        this.eventDate = eventDate;
        this.repositoryId = repositoryId;
        this.docUuid = docUuid;
        this.fileSystemItemId = fileSystemItemId;
        this.fileSystemItemName = fileSystemItemName;
    }

    public FileSystemItemChange(String eventId, long eventDate, String repositoryId, String docUuid, FileSystemItem fsItem) {
        this(eventId, eventDate, repositoryId, docUuid, fsItem.getId(), fsItem.getName());
        this.setFileSystemItem(fsItem);
    }

    public String getFileSystemItemId() {
        return this.fileSystemItemId;
    }

    public void setFileSystemItemId(String fileSystemItemId) {
        this.fileSystemItemId = fileSystemItemId;
    }

    public String getFileSystemItemName() {
        return this.fileSystemItemName;
    }

    public void setFileSystemItemName(String fileSystemItemName) {
        this.fileSystemItemName = fileSystemItemName;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public Long getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Long eventDate) {
        this.eventDate = eventDate;
    }

    public String getDocUuid() {
        return this.docUuid;
    }

    public void setDocUuid(String docUuid) {
        this.docUuid = docUuid;
    }

    public FileSystemItem getFileSystemItem() {
        return this.fileSystemItem;
    }

    @JsonIgnore
    public void setFileSystemItem(FileSystemItem fileSystemItem) {
        this.fileSystemItem = fileSystemItem;
    }

    public String toString() {
        if (this.fileSystemItem != null) {
            return String.format("%s(eventId=\"%s\", eventDate=%d, item=%s)", this.getClass().getSimpleName(), this.eventId, this.eventDate, this.fileSystemItem);
        }
        return String.format("%s(eventId=\"%s\", eventDate=%d)", this.getClass().getSimpleName(), this.eventId, this.eventDate);
    }
}

