/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.GetRoots", category="Services", label="Nuxeo Drive: Get Roots")
public class NuxeoDriveGetRootsOperation {
    public static final String ID = "NuxeoDrive.GetRoots";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;

    @OperationMethod
    public DocumentModelList run() throws ClientException {
        String respositoryName;
        boolean allRepositories = true;
        HttpServletRequest request = (HttpServletRequest)this.ctx.get((Object)"request");
        if (request != null && !StringUtils.isEmpty((String)(respositoryName = request.getHeader("X-NXRepository")))) {
            allRepositories = false;
        }
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Map roots = driveManager.getSynchronizationRoots(this.ctx.getPrincipal());
        DocumentModelListImpl rootDocumentModels = new DocumentModelListImpl();
        for (Map.Entry rootsEntry : roots.entrySet()) {
            if (this.session.getRepositoryName().equals(rootsEntry.getKey())) {
                Set references = ((SynchronizationRoots)rootsEntry.getValue()).refs;
                rootDocumentModels.addAll((Collection)this.session.getDocuments(references.toArray(new DocumentRef[references.size()])));
                continue;
            }
            if (!allRepositories) continue;
            throw new RuntimeException("Multi repo roots not yet implemented");
        }
        return rootDocumentModels;
    }
}

