/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.NuxeoDriveEvents;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.TooManyChangesException;
import org.nuxeo.drive.service.impl.FileSystemItemChange;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class AuditChangeFinder
implements FileSystemChangeFinder {
    private static final long serialVersionUID = 1963018967324857522L;
    private static final Log log = LogFactory.getLog(AuditChangeFinder.class);

    @Override
    public List<FileSystemItemChange> getFileSystemChanges(CoreSession session, Set<IdRef> lastActiveRootRefs, SynchronizationRoots activeRoots, long lastSuccessfulSyncDate, long syncDate, int limit) throws ClientException, TooManyChangesException {
        String principalName = session.getPrincipal().getName();
        ArrayList<FileSystemItemChange> changes = new ArrayList<FileSystemItemChange>();
        List<LogEntry> entries = this.queryAuditEntries(session, activeRoots, lastSuccessfulSyncDate, syncDate, limit);
        for (LogEntry entry : entries) {
            if (!NuxeoDriveEvents.EVENT_CATEGORY.equals(entry.getCategory())) continue;
            log.debug((Object)String.format("Detected sync root change for user '%s' in audit log: invalidating the root cache and refetching the changes.", principalName));
            NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
            driveManager.invalidateSynchronizationRootsCache(principalName);
            Map<String, SynchronizationRoots> synchronizationRoots = driveManager.getSynchronizationRoots(session.getPrincipal());
            activeRoots = synchronizationRoots.get(session.getRepositoryName());
            entries = this.queryAuditEntries(session, activeRoots, lastSuccessfulSyncDate, syncDate, limit);
            break;
        }
        if (entries.size() >= limit) {
            throw new TooManyChangesException("Too many changes found in the audit logs.");
        }
        for (LogEntry entry : entries) {
            DocumentModel doc;
            FileSystemItem fsItem;
            ExtendedInfo fsIdInfo = (ExtendedInfo)entry.getExtendedInfos().get("fileSystemItemId");
            if (fsIdInfo != null) {
                String fsId = (String)fsIdInfo.getValue(String.class);
                String fsName = (String)((ExtendedInfo)entry.getExtendedInfos().get("fileSystemItemName")).getValue(String.class);
                FileSystemItemChange change = new FileSystemItemChange(entry.getEventId(), entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsId, fsName);
                changes.add(change);
                continue;
            }
            IdRef docRef = new IdRef(entry.getDocUUID());
            if (!session.exists((DocumentRef)docRef) || (fsItem = (FileSystemItem)(doc = session.getDocument((DocumentRef)docRef)).getAdapter(FileSystemItem.class)) == null) continue;
            FileSystemItemChange change = new FileSystemItemChange(entry.getEventId(), entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsItem);
            changes.add(change);
        }
        return changes;
    }

    protected List<LogEntry> queryAuditEntries(CoreSession session, SynchronizationRoots activeRoots, long lastSuccessfulSyncDate, long syncDate, int limit) {
        AuditReader auditService = (AuditReader)Framework.getLocalService(AuditReader.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("repositoryId", session.getRepositoryName());
        StringBuilder auditQuerySb = new StringBuilder("from LogEntry log where ");
        auditQuerySb.append("log.repositoryId = :repositoryId");
        auditQuerySb.append(" and ");
        auditQuerySb.append("(");
        if (!activeRoots.paths.isEmpty()) {
            auditQuerySb.append("(");
            auditQuerySb.append("log.category = 'eventDocumentCategory'");
            auditQuerySb.append(" and (log.eventId = 'documentCreated' or log.eventId = 'documentModified' or log.eventId = 'documentMoved')");
            auditQuerySb.append(" or ");
            auditQuerySb.append("log.category = 'eventLifeCycleCategory'");
            auditQuerySb.append(" and log.eventId = 'lifecycle_transition_event' and log.docLifeCycle != 'deleted' ");
            auditQuerySb.append(") and (");
            auditQuerySb.append(this.getCurrentRootFilteringClause(activeRoots.paths, params));
            auditQuerySb.append(") or ");
        }
        auditQuerySb.append("log.category = '");
        auditQuerySb.append(NuxeoDriveEvents.EVENT_CATEGORY);
        auditQuerySb.append("') and (");
        auditQuerySb.append(this.getJPADateClause(lastSuccessfulSyncDate, syncDate, params));
        auditQuerySb.append(") order by log.repositoryId asc, log.eventDate desc");
        String auditQuery = auditQuerySb.toString();
        log.debug((Object)("Querying audit logs for document changes: " + auditQuery + " with params: " + params));
        List entries = auditService.nativeQuery(auditQuery, params, 1, limit);
        ArrayList<LogEntry> postFilteredEntries = new ArrayList<LogEntry>();
        String principalName = session.getPrincipal().getName();
        for (LogEntry entry : entries) {
            ExtendedInfo impactedUserInfo = (ExtendedInfo)entry.getExtendedInfos().get("impactedUserName");
            if (impactedUserInfo != null && !principalName.equals(impactedUserInfo.getValue(String.class))) continue;
            postFilteredEntries.add(entry);
        }
        return postFilteredEntries;
    }

    protected String getCurrentRootFilteringClause(Set<String> rootPaths, Map<String, Object> params) {
        StringBuilder rootPathClause = new StringBuilder();
        int rootPathCount = 0;
        for (String rootPath : rootPaths) {
            String rootPathParam = "rootPath" + ++rootPathCount;
            if (rootPathClause.length() > 0) {
                rootPathClause.append(" or ");
            }
            rootPathClause.append(String.format("log.docPath like :%s", rootPathParam));
            params.put(rootPathParam, rootPath + '%');
        }
        return rootPathClause.toString();
    }

    protected String getJPADateClause(long lastSuccessfulSyncDate, long syncDate, Map<String, Object> params) {
        params.put("lastSuccessfulSyncDate", new Date(lastSuccessfulSyncDate));
        params.put("syncDate", new Date(syncDate));
        return "log.eventDate >= :lastSuccessfulSyncDate and log.eventDate < :syncDate";
    }

    protected boolean adaptDocument(FileSystemItemChange change, CoreSession session, SynchronizationRoots synchronizationRoots) throws ClientException {
        IdRef ref = new IdRef(change.getDocUuid());
        try {
            DocumentModel doc = session.getDocument((DocumentRef)ref);
            FileSystemItem fsItem = (FileSystemItem)doc.getAdapter(FileSystemItem.class);
            if (fsItem == null) {
                return false;
            }
            change.setFileSystemItem(fsItem);
            return true;
        }
        catch (DocumentSecurityException e) {
            return false;
        }
    }
}

