/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.seam;

public class DesktopPackageDefinition {
    protected final String url;
    protected final String platform;
    protected final String name;

    public DesktopPackageDefinition(String path, String baseURL) throws IllegalArgumentException {
        this.url = baseURL + path.substring(1);
        if (path.endsWith(".msi")) {
            this.platform = "windows";
        } else if (path.endsWith(".dmg")) {
            this.platform = "osx";
        } else if (path.endsWith(".deb")) {
            this.platform = "ubuntu";
        } else {
            throw new IllegalArgumentException("Unsupported package name: " + path);
        }
        this.name = path.substring("/nuxeo-drive/".length());
    }

    public String getDownloadURL() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getPlatformLabel() {
        return "user.center.nuxeoDrive.platform." + this.platform;
    }

    public String getPlatformId() {
        return this.platform;
    }
}

