/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.operations.NuxeoDriveOperationHelper;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.UpdateFile", category="Services", label="Nuxeo Drive: Update file")
public class NuxeoDriveUpdateFile {
    public static final String ID = "NuxeoDrive.UpdateFile";
    @Context
    protected OperationContext ctx;
    @Param(name="id")
    protected String id;

    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
        NuxeoDriveOperationHelper.normalizeMimeTypeAndEncoding(blob);
        FileItem fileItem = fileSystemItemManager.updateFile(this.id, blob, this.ctx.getPrincipal());
        NuxeoDriveOperationHelper.commitAndReopenTransaction();
        return NuxeoDriveOperationHelper.asJSONBlob(fileItem);
    }
}

