/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.drive.service.impl.DefaultFileSystemItemFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class FileSystemItemManagerImpl
implements FileSystemItemManager {
    private static final Log log = LogFactory.getLog(DefaultFileSystemItemFactory.class);
    protected final ThreadLocal<Map<String, CoreSession>> openedSessions = new ThreadLocal<Map<String, CoreSession>>(){

        @Override
        protected Map<String, CoreSession> initialValue() {
            return new HashMap<String, CoreSession>();
        }
    };

    @Override
    public CoreSession getSession(String repositoryName, Principal principal) throws ClientException {
        String sessionKey = repositoryName + "/" + principal.getName();
        CoreSession session = this.openedSessions.get().get(sessionKey);
        if (session == null) {
            HashMap<String, Serializable> context = new HashMap<String, Serializable>();
            context.put("principal", (Serializable)((Object)principal));
            CoreSession newSession = CoreInstance.getInstance().open(repositoryName, context);
            this.openedSessions.get().put(sessionKey, newSession);
            try {
                Transaction t = TransactionHelper.lookupTransactionManager().getTransaction();
                if (t == null) {
                    throw new RuntimeException("FileSystemItemManagerImpl requires an active transaction.");
                }
                t.registerSynchronization((Synchronization)new SessionCloser(newSession, sessionKey));
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            session = newSession;
        }
        return session;
    }

    @Override
    public List<FileSystemItem> getTopLevelChildren(Principal principal) throws ClientException {
        return this.getTopLevelFolder(principal).getChildren();
    }

    @Override
    public FolderItem getTopLevelFolder(Principal principal) throws ClientException {
        return this.getFileSystemItemAdapterService().getTopLevelFolderItemFactory().getTopLevelFolderItem(principal);
    }

    @Override
    public boolean exists(String id, Principal principal) throws ClientException {
        return this.getFileSystemItemAdapterService().getFileSystemItemFactoryForId(id).exists(id, principal);
    }

    @Override
    public FileSystemItem getFileSystemItemById(String id, Principal principal) throws ClientException {
        try {
            return this.getFileSystemItemAdapterService().getFileSystemItemFactoryForId(id).getFileSystemItemById(id, principal);
        }
        catch (RootlessItemException e) {
            log.debug((Object)String.format("RootlessItemException thrown while trying to get file system item with id %s, returning null.", id));
            return null;
        }
    }

    @Override
    public List<FileSystemItem> getChildren(String id, Principal principal) throws ClientException {
        FileSystemItem fileSystemItem = this.getFileSystemItemById(id, principal);
        if (fileSystemItem == null) {
            throw new ClientException(String.format("Cannot get the children of file system item with id %s because it doesn't exist.", id));
        }
        if (!(fileSystemItem instanceof FolderItem)) {
            throw new ClientException(String.format("Cannot get the children of file system item with id %s because it is not a folder.", id));
        }
        FolderItem folderItem = (FolderItem)fileSystemItem;
        return folderItem.getChildren();
    }

    @Override
    public boolean canMove(String srcId, String destId, Principal principal) throws ClientException {
        FileSystemItem srcFsItem = this.getFileSystemItemById(srcId, principal);
        if (srcFsItem == null) {
            return false;
        }
        FileSystemItem destFsItem = this.getFileSystemItemById(destId, principal);
        if (!(destFsItem instanceof FolderItem)) {
            return false;
        }
        return srcFsItem.canMove((FolderItem)destFsItem);
    }

    @Override
    public FolderItem createFolder(String parentId, String name, Principal principal) throws ClientException {
        FileSystemItem parentFsItem = this.getFileSystemItemById(parentId, principal);
        if (parentFsItem == null) {
            throw new ClientException(String.format("Cannot create a folder in file system item with id %s because it doesn't exist.", parentId));
        }
        if (!(parentFsItem instanceof FolderItem)) {
            throw new ClientException(String.format("Cannot create a folder in file system item with id %s because it is not a folder but is: %s", parentId, parentFsItem));
        }
        FolderItem parentFolder = (FolderItem)parentFsItem;
        return parentFolder.createFolder(name);
    }

    @Override
    public FileItem createFile(String parentId, Blob blob, Principal principal) throws ClientException {
        FileSystemItem parentFsItem = this.getFileSystemItemById(parentId, principal);
        if (parentFsItem == null) {
            throw new ClientException(String.format("Cannot create a file in file system item with id %s because it doesn't exist.", parentId));
        }
        if (!(parentFsItem instanceof FolderItem)) {
            throw new ClientException(String.format("Cannot create a file in file system item with id %s because it is not a folder but is: %s", parentId, parentFsItem));
        }
        FolderItem parentFolder = (FolderItem)parentFsItem;
        return parentFolder.createFile(blob);
    }

    @Override
    public FileItem updateFile(String id, Blob blob, Principal principal) throws ClientException {
        FileSystemItem fsItem = this.getFileSystemItemById(id, principal);
        if (fsItem == null) {
            throw new ClientException(String.format("Cannot update the content of file system item with id %s because it doesn't exist.", id));
        }
        if (!(fsItem instanceof FileItem)) {
            throw new ClientException(String.format("Cannot update the content of file system item with id %s because it is not a file.", id));
        }
        FileItem file = (FileItem)fsItem;
        file.setBlob(blob);
        return file;
    }

    @Override
    public void delete(String id, Principal principal) throws ClientException {
        FileSystemItem fsItem = this.getFileSystemItemById(id, principal);
        if (fsItem == null) {
            throw new ClientException(String.format("Cannot delete file system item with id %s because it doesn't exist.", id));
        }
        fsItem.delete();
    }

    @Override
    public FileSystemItem rename(String id, String name, Principal principal) throws ClientException {
        FileSystemItem fsItem = this.getFileSystemItemById(id, principal);
        if (fsItem == null) {
            throw new ClientException(String.format("Cannot renamefile system item with id %s because it doesn't exist.", id));
        }
        fsItem.rename(name);
        return fsItem;
    }

    @Override
    public FileSystemItem move(String srcId, String destId, Principal principal) throws ClientException {
        FileSystemItem srcFsItem = this.getFileSystemItemById(srcId, principal);
        if (srcFsItem == null) {
            throw new ClientException(String.format("Cannot move file system item with id %s because it doesn't exist.", srcId));
        }
        FileSystemItem destFsItem = this.getFileSystemItemById(destId, principal);
        if (destFsItem == null) {
            throw new ClientException(String.format("Cannot move a file system item to file system item with id %s because it doesn't exist.", destId));
        }
        if (!(destFsItem instanceof FolderItem)) {
            throw new ClientException(String.format("Cannot move a file system item to file system item with id %s because it is not a folder.", destId));
        }
        return srcFsItem.move((FolderItem)destFsItem);
    }

    protected FileSystemItemAdapterService getFileSystemItemAdapterService() {
        return (FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class);
    }

    protected class SessionCloser
    implements Synchronization {
        protected final CoreSession session;
        protected final String sessionKey;

        protected SessionCloser(CoreSession session, String sessionKey) {
            this.session = session;
            this.sessionKey = sessionKey;
        }

        public void beforeCompletion() {
            CoreInstance.getInstance().close(this.session);
        }

        public void afterCompletion(int status) {
            FileSystemItemManagerImpl.this.openedSessions.get().remove(this.sessionKey);
            if (status != 3) {
                CoreInstance.getInstance().close(this.session);
            }
        }
    }
}

