/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth.servlet;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationException;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class TokenAuthenticationServlet
extends HttpServlet {
    private static final long serialVersionUID = 7792388601558509103L;
    private static final Log log = LogFactory.getLog(TokenAuthenticationServlet.class);
    protected static final String APPLICATION_NAME_PARAM = "applicationName";
    protected static final String DEVICE_ID_PARAM = "deviceId";
    protected static final String DEVICE_DESCRIPTION_PARAM = "deviceDescription";
    protected static final String PERMISSION_PARAM = "permission";
    protected static final String REVOKE_PARAM = "revoke";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Principal principal;
        String applicationName = req.getParameter(APPLICATION_NAME_PARAM);
        String deviceId = req.getParameter(DEVICE_ID_PARAM);
        String deviceDescription = req.getParameter(DEVICE_DESCRIPTION_PARAM);
        String permission = req.getParameter(PERMISSION_PARAM);
        String revokeParam = req.getParameter(REVOKE_PARAM);
        boolean revoke = Boolean.valueOf(revokeParam);
        if (!revoke && (StringUtils.isEmpty((String)applicationName) || StringUtils.isEmpty((String)deviceId) || StringUtils.isEmpty((String)permission))) {
            log.error((Object)"The following request parameters are mandatory to acquire an authentication token: applicationName, deviceId, permission.");
            resp.sendError(400);
            return;
        }
        if (revoke && (StringUtils.isEmpty((String)applicationName) || StringUtils.isEmpty((String)deviceId))) {
            log.error((Object)"The following request parameters are mandatory to revoke an authentication token: applicationName, deviceId.");
            resp.sendError(400);
            return;
        }
        applicationName = URIUtil.decode((String)applicationName);
        deviceId = URIUtil.decode((String)deviceId);
        if (!StringUtils.isEmpty((String)deviceDescription)) {
            deviceDescription = URIUtil.decode((String)deviceDescription);
        }
        if (!StringUtils.isEmpty((String)permission)) {
            permission = URIUtil.decode((String)permission);
        }
        if ((principal = req.getUserPrincipal()) == null) {
            resp.sendError(401);
            return;
        }
        String userName = principal.getName();
        String response = null;
        TokenAuthenticationService tokenAuthService = (TokenAuthenticationService)Framework.getLocalService(TokenAuthenticationService.class);
        try {
            if (!revoke) {
                response = tokenAuthService.acquireToken(userName, applicationName, deviceId, deviceDescription, permission);
            } else {
                String token = tokenAuthService.getToken(userName, applicationName, deviceId);
                if (token == null) {
                    response = String.format("No token found for userName %s, applicationName %s and deviceId %s; nothing to do.", userName, applicationName, deviceId);
                } else {
                    tokenAuthService.revokeToken(token);
                    response = String.format("Token revoked for userName %s, applicationName %s and deviceId %s.", userName, applicationName, deviceId);
                }
            }
            this.sendTextResponse(resp, response);
        }
        catch (TokenAuthenticationException e) {
            resp.sendError(404);
        }
    }

    protected void sendTextResponse(HttpServletResponse resp, String textResponse) throws IOException {
        resp.setContentType("text/plain");
        resp.setContentLength(textResponse.getBytes().length);
        ServletOutputStream out = resp.getOutputStream();
        out.write(textResponse.getBytes());
        out.close();
    }
}

