/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.VirtualFolderItemFactory;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryDescriptor;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryRegistry;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryWrapper;
import org.nuxeo.drive.service.impl.TopLevelFolderItemFactoryDescriptor;
import org.nuxeo.drive.service.impl.TopLevelFolderItemFactoryRegistry;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class FileSystemItemAdapterServiceImpl
extends DefaultComponent
implements FileSystemItemAdapterService {
    private static final Log log = LogFactory.getLog(FileSystemItemAdapterServiceImpl.class);
    public static final String FILE_SYSTEM_ITEM_FACTORY_EP = "fileSystemItemFactory";
    public static final String TOP_LEVEL_FOLDER_ITEM_FACTORY_EP = "topLevelFolderItemFactory";
    protected FileSystemItemFactoryRegistry fileSystemItemFactoryRegistry;
    protected TopLevelFolderItemFactoryRegistry topLevelFolderItemFactoryRegistry;
    protected List<FileSystemItemFactoryWrapper> fileSystemItemFactories;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (FILE_SYSTEM_ITEM_FACTORY_EP.equals(extensionPoint)) {
            this.fileSystemItemFactoryRegistry.addContribution((FileSystemItemFactoryDescriptor)contribution);
        } else if (TOP_LEVEL_FOLDER_ITEM_FACTORY_EP.equals(extensionPoint)) {
            this.topLevelFolderItemFactoryRegistry.addContribution((TopLevelFolderItemFactoryDescriptor)contribution);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (FILE_SYSTEM_ITEM_FACTORY_EP.equals(extensionPoint)) {
            this.fileSystemItemFactoryRegistry.removeContribution((FileSystemItemFactoryDescriptor)contribution);
        } else if (TOP_LEVEL_FOLDER_ITEM_FACTORY_EP.equals(extensionPoint)) {
            this.topLevelFolderItemFactoryRegistry.removeContribution((TopLevelFolderItemFactoryDescriptor)contribution);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void activate(ComponentContext context) {
        this.fileSystemItemFactoryRegistry = new FileSystemItemFactoryRegistry();
        this.topLevelFolderItemFactoryRegistry = new TopLevelFolderItemFactoryRegistry();
        this.fileSystemItemFactories = new ArrayList<FileSystemItemFactoryWrapper>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        this.fileSystemItemFactoryRegistry = null;
        this.topLevelFolderItemFactoryRegistry = null;
        this.fileSystemItemFactories = null;
    }

    public void applicationStarted(ComponentContext context) throws InstantiationException, IllegalAccessException, ClientException {
        this.sortFileSystemItemFactories();
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc) throws ClientException {
        return this.getFileSystemItem(doc, false, null, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) throws ClientException {
        return this.getFileSystemItem(doc, false, null, includeDeleted);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem) throws ClientException {
        return this.getFileSystemItem(doc, true, parentItem, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted) throws ClientException {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted);
    }

    @Override
    public FileSystemItemFactory getFileSystemItemFactoryForId(String id) throws ClientException {
        for (FileSystemItemFactoryWrapper factoryWrapper : this.fileSystemItemFactories) {
            FileSystemItemFactory factory = factoryWrapper.getFactory();
            if (!factory.canHandleFileSystemItemId(id)) continue;
            return factory;
        }
        TopLevelFolderItemFactory topLevelFolderItemFactory = this.getTopLevelFolderItemFactory();
        if (topLevelFolderItemFactory.canHandleFileSystemItemId(id)) {
            return topLevelFolderItemFactory;
        }
        throw new ClientException(String.format("No fileSystemItemFactory found for FileSystemItem with id %s. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\"> and make sure there is at least one defining a FileSystemItemFactory class for which the #canHandleFileSystemItemId(String id) method returns true.", id));
    }

    @Override
    public TopLevelFolderItemFactory getTopLevelFolderItemFactory() throws ClientException {
        if (this.topLevelFolderItemFactoryRegistry.factory == null) {
            throw new ClientException("Found no topLevelFolderItemFactory. Please check there is a contribution to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"topLevelFolderItemFactory\">.");
        }
        return this.topLevelFolderItemFactoryRegistry.factory;
    }

    @Override
    public VirtualFolderItemFactory getVirtualFolderItemFactory(String factoryName) throws ClientException {
        FileSystemItemFactory factory = this.getFileSystemItemFactory(factoryName);
        if (factory == null) {
            throw new ClientException(String.format("No factory named %s. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\">.", factoryName));
        }
        if (!(factory instanceof VirtualFolderItemFactory)) {
            throw new ClientException(String.format("Factory class %s for factory %s is not a VirtualFolderItemFactory.", factory.getClass().getName(), factory.getName()));
        }
        return (VirtualFolderItemFactory)factory;
    }

    public Map<String, FileSystemItemFactoryDescriptor> getFileSystemItemFactoryDescriptors() {
        return this.fileSystemItemFactoryRegistry.factoryDescriptors;
    }

    public List<FileSystemItemFactoryWrapper> getFileSystemItemFactories() {
        return this.fileSystemItemFactories;
    }

    public FileSystemItemFactory getFileSystemItemFactory(String name) {
        for (FileSystemItemFactoryWrapper factoryWrapper : this.fileSystemItemFactories) {
            FileSystemItemFactory factory = factoryWrapper.getFactory();
            if (!name.equals(factory.getName())) continue;
            return factory;
        }
        log.debug((Object)String.format("No fileSystemItemFactory named %s, returning null.", name));
        return null;
    }

    protected void sortFileSystemItemFactories() throws InstantiationException, IllegalAccessException, ClientException {
        this.fileSystemItemFactories = this.fileSystemItemFactoryRegistry.getOrderedFactories();
    }

    protected FileSystemItem getFileSystemItem(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean includeDeleted) throws ClientException {
        FileSystemItem fileSystemItem = null;
        TopLevelFolderItemFactory topLevelFolderItemFactory = this.getTopLevelFolderItemFactory();
        fileSystemItem = forceParentItem ? topLevelFolderItemFactory.getFileSystemItem(doc, parentItem, includeDeleted) : topLevelFolderItemFactory.getFileSystemItem(doc, includeDeleted);
        if (fileSystemItem != null) {
            return fileSystemItem;
        }
        log.debug((Object)String.format("The topLevelFolderItemFactory is not able to adapt document %s as a FileSystemItem => trying fileSystemItemFactories.", doc.getId()));
        FileSystemItemFactoryWrapper matchingFactory = null;
        for (FileSystemItemFactoryWrapper factory : this.fileSystemItemFactories) {
            if (!this.generalFactoryMatches(factory) && !this.docTypeFactoryMatches(factory, doc) && !this.facetFactoryMatches(factory, doc)) continue;
            matchingFactory = factory;
            try {
                fileSystemItem = forceParentItem ? factory.getFactory().getFileSystemItem(doc, parentItem, includeDeleted) : factory.getFactory().getFileSystemItem(doc, includeDeleted);
            }
            catch (RootlessItemException e) {
                throw new RootlessItemException(String.format("Cannot find path to registered top level when adapting document  '%s' (path: %s) with factory %s", doc.getTitle(), doc.getPathAsString(), factory.getFactory().getName()), e);
            }
            if (fileSystemItem == null) continue;
            log.debug((Object)String.format("Adapted document '%s' (path: %s) to item with path %s with factory %s", doc.getTitle(), doc.getPathAsString(), fileSystemItem.getPath(), factory.getFactory().getName()));
            return fileSystemItem;
        }
        if (matchingFactory == null) {
            log.debug((Object)String.format("None of the fileSystemItemFactories matches document %s => returning null. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\">.", doc.getId()));
        } else {
            log.debug((Object)String.format("None of the fileSystemItemFactories matching document %s were able to adapt this document as a FileSystemItem => returning null.", doc.getId()));
        }
        return fileSystemItem;
    }

    protected boolean generalFactoryMatches(FileSystemItemFactoryWrapper factory) {
        return StringUtils.isEmpty((String)factory.getDocType()) && StringUtils.isEmpty((String)factory.getFacet());
    }

    protected boolean docTypeFactoryMatches(FileSystemItemFactoryWrapper factory, DocumentModel doc) {
        return !StringUtils.isEmpty((String)factory.getDocType()) && factory.getDocType().equals(doc.getType());
    }

    protected boolean facetFactoryMatches(FileSystemItemFactoryWrapper factory, DocumentModel doc) throws ClientException {
        if (!StringUtils.isEmpty((String)factory.getFacet())) {
            for (String docFacet : doc.getFacets()) {
                if (!factory.getFacet().equals(docFacet)) continue;
                if ("DriveSynchronized".equals(docFacet)) {
                    return this.syncRootFactoryMatches(doc);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean syncRootFactoryMatches(DocumentModel doc) throws ClientException {
        String userName = doc.getCoreSession().getPrincipal().getName();
        List subscriptions = (List)((Object)doc.getPropertyValue("drv:subscriptions"));
        for (Map subscription : subscriptions) {
            if (!userName.equals(subscription.get("username")) || !Boolean.TRUE.equals(subscription.get("enabled"))) continue;
            return true;
        }
        return false;
    }
}

