/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import org.nuxeo.connect.NuxeoConnectClient;

public class ConnectUrlConfig {
    public static final String CONNECT_DEFAULT_BASEURL = "https://connect.nuxeo.com/nuxeo/site/";
    public static final String CONNECT_URL_PROPERTY = "org.nuxeo.connect.url";
    public static final String CONNECT_PROXY_HOST_PROPERTY = "org.nuxeo.connect.proxy.host";
    public static final String CONNECT_PROXY_PORT_PROPERTY = "org.nuxeo.connect.proxy.port";
    public static final String CONNECT_PROXY_LOGIN_PROPERTY = "org.nuxeo.connect.proxy.login";
    public static final String CONNECT_PROXY_PASSWORD_PROPERTY = "org.nuxeo.connect.proxy.password";
    public static final String CONNECT_PROXY_NTLM_HOST = "org.nuxeo.connect.proxy.ntlm.host";
    public static final String CONNECT_PROXY_NTLM_DOMAIN = "org.nuxeo.connect.proxy.ntlm.domain";
    public static final String NUXEO_PROXY_HOST_PROPERTY = "nuxeo.http.proxy.host";
    public static final String NUXEO_PROXY_PORT_PROPERTY = "nuxeo.http.proxy.port";
    public static final String NUXEO_PROXY_LOGIN_PROPERTY = "nuxeo.http.proxy.login";
    public static final String NUXEO_PROXY_PASSWORD_PROPERTY = "nuxeo.http.proxy.password";
    public static final String NUXEO_PROXY_NTLM_HOST = "nuxeo.http.proxy.ntlm.host";
    public static final String NUXEO_PROXY_NTLM_DOMAIN = "nuxeo.http.proxy.ntlm.domain";
    public static final String CONNECT_ROOT_PATH = "connect-gateway/";
    public static final String CONNECT_REGISTERED_ROOT_PATH = "registred/";
    public static final String CONNECT_UNREGISTERED_ROOT_PATH = "unregistered/";
    protected static Boolean useProxy = null;
    protected static Boolean isProxyAuthenticated = null;

    public static String getBaseUrl() {
        if (NuxeoConnectClient.isTestModeSet()) {
            return "http://127.0.0.1:8082/";
        }
        return NuxeoConnectClient.getProperty(CONNECT_URL_PROPERTY, CONNECT_DEFAULT_BASEURL);
    }

    public static String getDownloadBaseUrl() {
        return ConnectUrlConfig.getBaseUrl().replace("/site/", "");
    }

    public static String getRegistrationBaseUrl() {
        return ConnectUrlConfig.getBaseUrl() + CONNECT_ROOT_PATH;
    }

    public static String getRegistredBaseUrl() {
        return ConnectUrlConfig.getRegistrationBaseUrl() + CONNECT_REGISTERED_ROOT_PATH;
    }

    public static String getUnregisteredBaseUrl() {
        return ConnectUrlConfig.getRegistrationBaseUrl() + CONNECT_UNREGISTERED_ROOT_PATH;
    }

    public static boolean useProxy() {
        if (useProxy == null) {
            String host = ConnectUrlConfig.getProxyHost();
            useProxy = host == null || host.isEmpty() || host.startsWith("$") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return useProxy;
    }

    public static boolean isProxyAuthenticated() {
        if (isProxyAuthenticated == null) {
            String login = ConnectUrlConfig.getProxyLogin();
            isProxyAuthenticated = login == null || login.isEmpty() || login.startsWith("$") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return isProxyAuthenticated;
    }

    public static String getProxyHost() {
        return NuxeoConnectClient.getProperty(CONNECT_PROXY_HOST_PROPERTY, NuxeoConnectClient.getProperty(NUXEO_PROXY_HOST_PROPERTY, null));
    }

    public static int getProxyPort() {
        String portAsString = NuxeoConnectClient.getProperty(CONNECT_PROXY_PORT_PROPERTY, NuxeoConnectClient.getProperty(NUXEO_PROXY_PORT_PROPERTY, null));
        if (portAsString == null || portAsString.isEmpty() || portAsString.startsWith("$")) {
            return 80;
        }
        try {
            return Integer.parseInt(portAsString);
        }
        catch (NumberFormatException e) {
            return 80;
        }
    }

    public static String getProxyLogin() {
        return NuxeoConnectClient.getProperty(CONNECT_PROXY_LOGIN_PROPERTY, NuxeoConnectClient.getProperty(NUXEO_PROXY_LOGIN_PROPERTY, null));
    }

    public static String getProxyPassword() {
        return NuxeoConnectClient.getProperty(CONNECT_PROXY_PASSWORD_PROPERTY, NuxeoConnectClient.getProperty(NUXEO_PROXY_PASSWORD_PROPERTY, null));
    }

    public static String getProxyNTLMHost() {
        return NuxeoConnectClient.getProperty(CONNECT_PROXY_NTLM_HOST, NuxeoConnectClient.getProperty(NUXEO_PROXY_NTLM_HOST, null));
    }

    public static String getProxyNTLMDomain() {
        return NuxeoConnectClient.getProperty(CONNECT_PROXY_NTLM_DOMAIN, NuxeoConnectClient.getProperty(NUXEO_PROXY_NTLM_DOMAIN, null));
    }

    public static boolean isProxyNTLM() {
        String host = ConnectUrlConfig.getProxyNTLMHost();
        if (host == null || host.isEmpty() || host.startsWith("$")) {
            return false;
        }
        String domain = ConnectUrlConfig.getProxyNTLMDomain();
        return domain != null && !domain.isEmpty() && !domain.startsWith("$");
    }
}

