/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.registration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.connector.http.ProxyHelper;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;

public class RegistrationHelper {
    public static final String GET_PROJECTS_SUFFIX = "getAvailableProjectsForRegistration";
    public static final String POST_REGISTER_SUFFIX = "remoteRegisterInstance";

    protected static String getBaseUrl() {
        return ConnectUrlConfig.getRegistrationBaseUrl();
    }

    protected static void configureHttpClient(HttpClient httpClient, String login, String password) {
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        httpClient.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials ba = new UsernamePasswordCredentials(login, password);
        httpClient.getState().setCredentials(new AuthScope(null, -1, AuthScope.ANY_REALM), (Credentials)ba);
        ProxyHelper.configureProxyIfNeeded(httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConnectProject> getAvailableProjectsForRegistration(String login, String password) {
        ArrayList<ConnectProject> result;
        block8: {
            String url = RegistrationHelper.getBaseUrl() + GET_PROJECTS_SUFFIX;
            HttpClient httpClient = new HttpClient();
            RegistrationHelper.configureHttpClient(httpClient, login, password);
            GetMethod method = new GetMethod(url);
            result = new ArrayList<ConnectProject>();
            try {
                int rc = httpClient.executeMethod((HttpMethod)method);
                if (rc != 200) break block8;
                String json = method.getResponseBodyAsString();
                try {
                    JSONArray array = new JSONArray(json);
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject ob = (JSONObject)array.get(i);
                        result.add(AbstractJSONSerializableData.loadFromJSON(ConnectProject.class, ob));
                    }
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
            catch (Exception e) {
            }
            finally {
                method.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String remoteRegisterInstance(String login, String password, String prjId, NuxeoClientInstanceType type, String description) throws Exception {
        String url = RegistrationHelper.getBaseUrl() + POST_REGISTER_SUFFIX;
        HttpClient httpClient = new HttpClient();
        RegistrationHelper.configureHttpClient(httpClient, login, password);
        PostMethod method = new PostMethod(url);
        NameValuePair project = new NameValuePair("projectId", prjId);
        NameValuePair desc = new NameValuePair("description", description);
        NameValuePair strType = new NameValuePair("type", type.getValue());
        NameValuePair ctid = new NameValuePair("CTID", TechnicalInstanceIdentifier.instance().getCTID());
        method.setRequestBody(new NameValuePair[]{project, desc, strType, ctid});
        try {
            int rc = httpClient.executeMethod((HttpMethod)method);
            if (rc == 200) {
                String string = method.getResponseBodyAsString();
                return string;
            }
        }
        catch (Exception e) {
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }
}

