/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.security.Principal;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractFileSystemItemFactory
implements FileSystemItemFactory {
    private static final Log log = LogFactory.getLog(AbstractFileSystemItemFactory.class);
    protected String name;

    @Override
    public abstract void handleParameters(Map<String, String> var1) throws ClientException;

    @Override
    public abstract boolean isFileSystemItem(DocumentModel var1, boolean var2, boolean var3) throws ClientException;

    protected abstract FileSystemItem adaptDocument(DocumentModel var1, boolean var2, FolderItem var3, boolean var4) throws ClientException;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc) throws ClientException {
        return this.isFileSystemItem(doc, false);
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted) throws ClientException {
        return this.isFileSystemItem(doc, includeDeleted, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc) throws ClientException {
        return this.getFileSystemItem(doc, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) throws ClientException {
        return this.getFileSystemItem(doc, false, null, includeDeleted, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) throws ClientException {
        return this.getFileSystemItem(doc, false, null, includeDeleted, relaxSyncRootConstraint);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem) throws ClientException {
        return this.getFileSystemItem(doc, parentItem, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted) throws ClientException {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint) throws ClientException {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, relaxSyncRootConstraint);
    }

    @Override
    public boolean canHandleFileSystemItemId(String id) {
        try {
            this.parseFileSystemId(id);
        }
        catch (ClientException e) {
            log.trace((Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean exists(String id, Principal principal) throws ClientException {
        try {
            DocumentModel doc = this.getDocumentByFileSystemId(id, principal);
            return this.isFileSystemItem(doc);
        }
        catch (ClientException e) {
            if (e.getCause() instanceof NoSuchDocumentException) {
                log.debug((Object)String.format("No doc related to id %s, returning false.", id));
                return false;
            }
            throw e;
        }
    }

    @Override
    public FileSystemItem getFileSystemItemById(String id, Principal principal) throws ClientException {
        try {
            DocumentModel doc = this.getDocumentByFileSystemId(id, principal);
            return this.getFileSystemItem(doc);
        }
        catch (ClientException e) {
            if (e.getCause() instanceof NoSuchDocumentException) {
                log.debug((Object)String.format("No doc related to id %s, returning null.", id));
                return null;
            }
            throw e;
        }
    }

    protected FileSystemItem getFileSystemItem(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint) throws ClientException {
        if (!this.isFileSystemItem(doc, includeDeleted, relaxSyncRootConstraint)) {
            log.trace((Object)String.format("Document %s cannot be adapted as a FileSystemItem => returning null.", doc.getId()));
            return null;
        }
        return this.adaptDocument(doc, forceParentItem, parentItem, relaxSyncRootConstraint);
    }

    protected String[] parseFileSystemId(String id) throws ClientException {
        String[] idFragments = id.split("#");
        if (idFragments.length != 3) {
            throw new ClientException(String.format("FileSystemItem id %s cannot be handled by factory named %s. Should match the 'fileSystemItemFactoryName#repositoryName#docId' pattern.", id, this.name));
        }
        String factoryName = idFragments[0];
        if (!this.name.equals(factoryName)) {
            throw new ClientException(String.format("Factoy name [%s] parsed from id %s does not match the actual factory name [%s].", factoryName, id, this.name));
        }
        return idFragments;
    }

    protected DocumentModel getDocumentByFileSystemId(String id, Principal principal) throws ClientException {
        String[] idFragments = this.parseFileSystemId(id);
        String repositoryName = idFragments[1];
        String docId = idFragments[2];
        CoreSession session = ((FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class)).getSession(repositoryName, principal);
        return this.getDocumentById(docId, session);
    }

    protected DocumentModel getDocumentById(String docId, CoreSession session) throws ClientException {
        return session.getDocument((DocumentRef)new IdRef(docId));
    }
}

